function [ret] = eval_yield(T, HfXO, HfXOO) 
    S  = [0 0 -1 1 1 -1
      -1 -1 0 0 0 1
      1 1 0 0 0 -1
      1 0 0 0 -2 1
      -1 0 0 0 2 -1];
  
     A = 0.05^2 * 3.14159; %dm^2, Cross sectional area
    L = 150; %dm, Length of PFR
    Ft = 2.5; %mol/s, Total molar flow rate
    Fi = [0.01 0.33 0.66 0 0 0]; %, inlet ratio
    Fi = Fi .* Ft; 
    %Create an anonymous set of functions that represents the
    %concentrations at each step
    odefun = @(t,y)A.*S'*eval_rates(T, HfXO, HfXOO, y)';
    
    %Options to set tighter tolerances
    options = odeset('RelTol', 1e-5, 'AbsTol', 1e-10);
    %Run ode15s to solve the problem. The problem is a little stiff due to
    %the initial timepoints
    [t,Y] = ode15s(odefun, [0 L], Fi, options);
    
    %Returns the yield.
    ret = Y(end, 4)/Fi(3);
end