function tam_HW4_P3_3
    %Generate plot that shows that the effect on T on the maxima is
    %monotonically increasing
    
    T = 200:25:700; %K
    mxs = zeros(1, length(T)); %Vector to store yields
    
    %Find max holding T constant
    for i = 1:length(T)
        [x,fval]=fminsearch(@(x)-eval_yield(T(i), x(1), x(2)),[-50, -100]);
        mxs(i) = -fval;
    end
    
    plot(T, mxs)
    xlabel('Temp (K)')
    ylabel('Max yield')

    %Roughly find areas of high maxima by sampling points in the area 
    [X,Y] = meshgrid(0:-10:-200, 0:-10:-200); %Create sampling grid
    sz = size(X);
    vals = zeros(sz(1), sz(2)); %Create a grid of Xs for testing
    %Loop through the grid and test them
    for i = 1:sz(1)
        for j = 1:sz(2)
            vals(i,j) = eval_yield(700, X(i,j), Y(i,j));
        end
    end
    figure
    contour(X,Y,vals, 20)
    xlabel('HfXO')
    ylabel('HfXOO')
    
    %Here's a finer-grained look at area near the maximum.
    [X,Y] = meshgrid(-55:0.5:-35, -115:0.5:-95);

    sz = size(X);
    vals = zeros(sz(1), sz(2));
    for i = 1:sz(1)
        for j = 1:sz(2)
            vals(i,j) = eval_yield(700, X(i,j), Y(i,j));
        end
    end
    figure
    contour(X,Y,vals, 100)
    xlabel('HfXO')
    ylabel('HfXOO')
    
    %We use this to display the optimizations and stabilize the iterations.
    options = optimoptions(@fmincon, 'Algorithm', 'sqp', 'Display', 'Iter', 'DiffMinChange', 1e-4);
    
    %This is what we get using the guess provided
    [x,fval,exitflag,output,lambda,grad,hessian]=fmincon(@(x)-eval_yield(x(1), x(2), x(3)),[650, -30, -80],[1 0 0; 0 -1 0; 0 0 -1],[700 300 300],[],[],[],[],[])
    
    %This is what we get using the provided guess and the options above:
    %higher than 0.9
    [x,fval,exitflag,output,lambda,grad,hessian]=fmincon(@(x)-eval_yield(x(1), x(2), x(3)),[650, -30, -80],[1 0 0; 0 -1 0; 0 0 -1],[700 300 300],[],[],[],[],[],options)

    %using a better guess,
    [x,fval,exitflag,output,lambda,grad,hessian]=fmincon(@(x)-eval_yield(x(1), x(2), x(3)),[700, -46, -102],[1 0 0; 0 -1 0; 0 0 -1],[700 300 300],[],[],[],[],[], options)
    
end
