% Define the reaction rates as a function
% of the energetic parameters HfXO and HfXOO
% and T (K). Requires F vector of components.
% Returns a 5-vector with the various reaction rates
% Component ordering: X, O2, alkene, epoxide, XO, XOO
function [ret, E] = eval_rates(T, HfXO, HfXOO, f)
   
    %Define ideal gas const
    R = 8.314e-3; % kJ/molK
    P = 1e6; %Pa
    %Define Qs
    q = [40 5 5 32 32]; %kJ/mol
    %Define the activation energies
    dH = [HfXO-HfXOO-105 HfXOO -HfXOO HfXOO-2*HfXO 2*HfXO-HfXOO];
    E = 1/2 .* dH + (q.^2 + (1/2.*dH).^2).^(1/2);
    %define the constant part of the rates
    kc = [1e6 1e9 1e14 1e8 1e8];
    Cout = P / (R*T) * 1e-6; %Conversion to mol/L
    c = Cout * f / sum(f);
    conc = [c(3)*c(6) c(1)*c(2) c(6) c(5)^2 c(1)*c(6)];
    ret = kc .* exp(-E ./ (R*T)) .* conc;
end