function [tvec, Y] = my_ode_solver(fname, t0, tf, y0, options, params)
%Inputs:

%Outputs:



%% RK2 with fixed time step
if options(1) > 0 && options(2) > 0
    deltaT = options(2);
    
    %Because the time step is constant, pre-allocate the size of tvec and Y
    tvec = zeros(floor((tf-t0)/deltaT)+1,1);
    a = length(y0);
    Y = zeros(floor((tf-t0)/deltaT)+1,a);
    
    %Use the initial condition
    tvec(1) = t0; %initialize t
    Y(1,:) = y0; %initialize y
    
    index = 1;
    t = t0 + deltaT;
    
    while t < tf
        
        %find the estimate of the derivative
        dydt = fname(t,Y(index,:) + 1/2*deltaT*fname(t,Y(index,:),params),params);
        %calculate the value of Y
        Y(index + 1,:) = Y(index,:) + deltaT*dydt;
        %store the value of t
        tvec(index + 1) = t;
        
        
        t = t + deltaT; %update the time
        index = index + 1; %update the index counter
    end %end while loop
    t = tf;
    dydt = fname(t,Y(end-1,:) + 1/2*deltaT*fname(t,Y(end-1,:),params),params);
    Y(end,:) = Y(index,:) + deltaT*dydt;
    tvec(end) = tf;
    
end %end if statement

%% CN and RK2 with adaptive time step
if options(2) < 0
    deltaT = abs(options(2));
    atol = options(4);
    rtol = options(5);
    
    %Use the initial condition
    tvec(1) = t0; %initialize t
    Y(1,:) = y0; %initialize y
    
    index = 1;
    
    while tvec(index) < tf
        
        %find the RK2 estimate of the derivative
        dydtRK2 = fname(tvec(index),Y(index,:) + 1/2*deltaT*fname(tvec(index),Y(index,:),params),params);
        
        %find the CN estimate of the derivative
        fun = @(ynew) Y(index,:) + deltaT*1/2*(fname(tvec(index),Y(index,:),params) + fname(tvec(index)+deltaT,ynew,params)) - ynew;
        
        %calculate the value of Y
        yguess = Y(index,:) + deltaT*dydtRK2;
        Ynew = fsolve(fun, yguess);
        
        if deltaT < 10^-8
            Y(index + 1,:) = Y(index,:) + deltaT*dydtRK2;
            tvec(index + 1) = tvec(index) + deltaT;
            
            index = index + 1;
        elseif norm(deltaT*dydtRK2 - (Ynew - Y(index,:))) > atol + rtol*norm(Y(index,:))
            
            deltaT = deltaT/2;
            
        else
            if options(1) > 0
                Y(index + 1,:) = Y(index,:) + deltaT*dydtRK2;
                tvec(index + 1) = tvec(index) + deltaT;
                
                deltaT = deltaT*options(3);
                
                index = index + 1;
            elseif options(1) < 0
                Y(index + 1,:) = Ynew;
                tvec(index + 1) = tvec(index) + deltaT;
                
                deltaT = deltaT*options(3);
                
                index = index + 1;
            else 
                disp('There is a problem with your options vector')
                break
            end
        end %end if statement
        
        
    end %end while loop
    t = tf;
    dydt = fname(t,Y(end-1,:) + 1/2*deltaT*fname(t,Y(end-1,:),params),params);
    if options(1) > 0
                
        Y(end,:) = Y(index,:) + deltaT*dydt;
        tvec(end) = tf;
        
    else
        
        yguess = Y(index,:) + deltaT*dydt;
        Y(end,:) = fsolve(fun, yguess);
        tvec(end) = tf;
            
    end
    
end %end if statement

%% CN with fixed time step
if options(1) < 0 && options(2) > 0
    deltaT = options(2);
    
    %Because the time step is constant, pre-allocate the size of tvec and Y
    tvec = zeros(floor((tf-t0)/deltaT)+1,1);
    a = length(y0);
    Y = zeros(floor((tf-t0)/deltaT)+1,a);
    
    %Use the initial condition
    tvec(1) = t0; %initialize t
    Y(1,:) = y0; %initialize y
    
    index = 1;
    t = t0 + deltaT;
    
    while t < tf
        
        %find the estimate of the derivative
        fun = @(ynew) Y(index,:) + deltaT*1/2*(fname(t,Y(index,:),params) + fname(t+deltaT,ynew,params)) - ynew;
        
        %calculate the value of Y
        dydt = fname(t,Y(index,:) + 1/2*deltaT*fname(t,Y(index,:),params),params);
        %use Runge-Kutta as the initial guess
        yguess = Y(index,:) + deltaT*dydt;
        Y(index + 1,:) = fsolve(fun, yguess);
        tvec(index + 1) = t;
        
        t = t + deltaT; %update the time
        index = index + 1; %update the index counter
    end
    t = tf;
    %calculate the value of Y
    dydt = fname(t,Y(index,:) + 1/2*deltaT*fname(t,Y(index,:),params),params);
    %use Runge-Kutta as the initial guess
    yguess = Y(index,:) + deltaT*dydt;
    Y(end,:) = fsolve(fun, yguess);
    tvec(end) = t;
    
end




end %end function