%% Script for HW4

clear 
close all 
clc

%% Parameters and variables used for the cylindrical rod problem from HW0
R=0.2;  % radius of cylinder (m)
delta=0.01; % integrate close to center of cylinder, but not too close
t0 = 0; %starting point of integration
tf = R - delta; %ending point of integration (not exactly at the center)
ylimits = [t0,tf]; %vector of limits
qdot= 20000; % (W/m^3)
Tsurface =393;  % (K)
k = 148*(Tsurface./300).^(-1.3);  % (W/m-K)
%Defining the initial conditions for the first order coupled differential
%   equations
y0=[Tsurface, -0.5*R*qdot/k]; % Units in [K, K/m]
%Define necessary parameters for subfunctions
params = [R,qdot];

%% Apply the different solvers to the problem

% Solve using ode23 and default tolerances
[tvec23, Y23] = ode23(@(t,Y) fname(t,Y,params),ylimits,y0);
strend = ['End point temp = ',num2str(Y23(end,1))];

ODE_plotter(tvec23,Y23,' ODE23 with Default Tolerances')

options = odeset('RelTol',1e-10,'AbsTol',1e-10);
[tvec23_2, Y23_2] = ode23(@(t,Y) fname(t,Y,params),ylimits,y0,options);

ODE_plotter(tvec23_2, Y23_2,' ODE23 with RelTol and AbsTol = 10^{-10}')

%choose the initial step size
step = 1e-2;

% RK2 with fixed time step
% RK2options = [1, step];
% [tvecRKF, YRKF] = my_ode_solver(@fname, t0, tf, y0, RK2options, params);
% 
% ODE_plotter(tvecRKF,YRKF,strcat(' RK2 with fixed step = ',num2str(RK2options(2))))
% 
% %RK2 with adaptive time step
% RK2_a_options = [1, -step, 1.5, 10^-8, 10^-8];
% [tvecRKA, YRKA] = my_ode_solver(@fname, t0, tf, y0, RK2_a_options, params);
% 
% ODE_plotter(tvecRKA, YRKA,' RK2 with adaptive step')

% CN with fixed time step
CNoptions = [-1, step];
[tvecCNF, YCNF] = my_ode_solver(@fname, t0, tf, y0, CNoptions, params);

ODE_plotter(tvecCNF,YCNF,strcat('CN with fixed step = ',num2str(CNoptions(2))))
return
% CN with adaptive time step
CNAoptions = [-1, -step, 1.05, 10^-8, 10^-8];
[tvecCNA, YCNA] = my_ode_solver(@fname, t0, tf, y0, CNAoptions, params);

ODE_plotter(tvecCNA,YCNA,'CN with adaptive step ')



