%% Script for HW4 P2

clear 
close all
clc


%% Parameters and variables used for the cylindrical rod problem from HW0
R = 0.2; %radius in m
delta=0.01; % integrate close to center of cylinder, but not too close
t0 = 0; %starting point of integration
tf = R - delta; %ending point of integration (not exactly at the center)
ylimits = [t0,tf]; %vector of limits
qdot= 20000; % (W/m^3)
Tsurface =393;  % (K)
k = 148*(Tsurface./300).^(-1.3);  % (W/m-K)
%Defining the initial conditions for the first order coupled differential
%   equations
y0=[Tsurface, -0.5*R*qdot/k, 0, 1, -0.5*R/k, -0.65*R*qdot/148/300*(Tsurface/300)^(0.3)]; % Units in [K, K/m]
%Define necessary parameters for subfunctions
params = [R,qdot];

%choose the initial step size
step = 1e-4;

% CN with adaptive time step
%CNAoptions = [-1, -step, 1.5, 10^-8, 10^-8];
%[tvecCNA, YCNA] = my_ode_solver(@fname_2, t0, tf, y0, CNAoptions, params);

ode=@(y,u)fname_2(y,u,params);
 [~,Uode23]=ode23(ode,ylimits,y0);

deltaP1 = 5000;
deltaP2 = 1;

del_u1 = sqrt((Uode23(end,3)*deltaP1)^2 + (Uode23(end,4)*deltaP2)^2)
del_u2 = sqrt((Uode23(end,5)*deltaP1)^2 + (Uode23(end,6)*deltaP2)^2)
return
del_u1 = sqrt((YCNA(end,3)*deltaP1)^2 + (YCNA(end,4)*deltaP2)^2)
del_u2 = sqrt((YCNA(end,5)*deltaP1)^2 + (YCNA(end,6)*deltaP2)^2)
