function dydt = fname_2(t,y,params)

%Extract parameters:
R = params(1);
qdot = params(2);

%Intialize the output vector to zero
dydt = zeros(size(y));

%Evaluate k(T):
k = 148*(y(1)./300).^(-1.3);

%Choose a value for the step size in the Jacobian
epsilon = 10^-3.*ones(6,1);

f_u = @(w) [-w(2), w(2)/(R-t) + qdot/(148*(w(1)./300).^(-1.3))];
f_p = @(p) [-y(1), y(2)/(R-t) + p(1)/(148*(y(1)./300).^(-1.3))];

p_val = [qdot, 0];

jac_u =  jacobian_solve(f_u,y(1:2),epsilon);
jac_p = jacobian_solve(f_p,p_val,epsilon);


%Fill the values for output vector
dydt(1) = -y(2);
dydt(2) = y(2)/(R-t) + qdot./k;
dydt(3) = jac_p(1,1) + jac_u(1,1)*y(3) + jac_u(1,2)*y(5);
dydt(4) = jac_p(1,2) + jac_u(1,1)*y(4) + jac_u(1,2)*y(6);
dydt(5) = jac_p(2,1) + jac_u(2,1)*y(3) + jac_u(2,2)*y(5);
dydt(6) = jac_p(2,2) + jac_u(2,1)*y(4) + jac_u(2,2)*y(6);

end %end function