function green_HW6_P2
    %moorejs_HW7_P1
    %Written by: Jason Moore on Nov 3, 2010
    %Input: (none)
    %Output: (none)
    %This function solves a reaction-diffusion problem:
    %   DA * d2cA/dx2 - kA * cA = 0
    %using the shooting method and ode45

    %Suppress warning messages
    warning('off')

    %Define system parameters
    D = 0.022E-4; %(m^2/s)  for cases 'a' and 'c'
    H = 2.2E-2; %(m)
    CA0 = 0.0012*1E3; %(mol/m^3)
    alpha = 1.1E-5; %m^2/s
    dH = -50e3; %J/mol 
    Cp = 0.4e4; %J/m^3-K
    T0 = 300; %K
    A = 1.1E9; %s
    E = 101e3; %J/mol
    k = 0.041; %s^-1
    Cmin=5E-2; %mole/m3
    Csat= 1; % mole/m3
    Dliquid = 1E-9; % m^2/s   for case 'b'
    params = [D;H;CA0;alpha;dH;Cp;T0;A;E;k;Cmin;Csat;Dliquid];

    Z0 = [-150;0];

    options = optimset('MaxFunEvals',1E3,'TolFun',1E-8);
    Z = fsolve(@(Z)ZShoot(Z,params),Z0,options)

    [t,y]=ZSolve(Z,params);

    %Compute the exact solution
    L = sqrt(D/k);
    cA_exact = CA0*cosh((H-t)/L)/cosh(H/L);

    plot((H-t)/H,y(:,1)/1E3,'rs',(H-t)/H,cA_exact/1E3,'-*')
    xlabel('Position in Slab / B')
    ylabel('Concentration (M)')
    legend('Shooting Method','Analytical Solution')
    figure
    plot((H-t)/H,y(:,3))
    xlabel('Position in Slab / B')
    ylabel('Temperature (K)')


function Error = ZShoot(Z,params)
%Written by: Jason Moore on Nov 3, 2010
%Inputs:
%   Z - guess at initial conditions [dC/dt; dT/dt]
%       units of Z:  mole/m^4, K/m
%   params - system parameters
%Output:
%   Error - error in shooting method
%Finds the values of Z which solves the system

[t,y] = ZSolve(Z,params);

Error = [y(end,2),y(end,4)];


function [t,y] = ZSolve(Z,params)
%Written by: Jason Moore on Nov 3, 2010
%Inputs:
%   Z - guess at initial conditions [dC/dt; dT/dt]
%   params - system parameters
%Output:
%   t - distance into slab from surface (t = B/2 - x)
%   y - vector of [CA; dCA/dt; T; dT/dt]
%Solve the system ODE

H = params(2);
CA0 = params(3);
T0 = params(7);

y0 = [CA0; Z(1); T0; Z(2)];

options = odeset('RelTol',1E-6);
[t,y] = ode45(@(t,y)slabODE(t,y,params),[0,H],y0,options);

%//////////////////////////////////////////////////////////////////////////

function dy_dt = slabODE(t,y,params)
%Written by: Jason Moore on Nov 3, 2010
%Inputs:
%   t - distance into slab from surface (t = B/2 - x)
%   y - vector of [CA; dCA/dt; T; dT/dt]
%   params - system parameters
%Output:
%   dy_dt - derivatives of y
%Calculate the derivatives of the system

D = params(1);
B = params(2);
CA0 = params(3);
alpha = params(4);
dH = params(5);
Cp = params(6);
T0 = params(7);
A = params(8);
E = params(9);
k = params(10);
Cmin = params(11);
Csat = params(12);

r = k*y(1);  %only for cases a and c
dy_dt(1,1) = y(2);
dy_dt(2,1) = r/D;
dy_dt(3,1) = y(4);
dy_dt(4,1) = dH/(alpha*Cp)*r;