with Truss;
use Truss;


procedure Solve_My_Truss is
   Joints : Jointarray;
   Forces : Forcearray;
   Loads : Loadarray;
   Num_Bars : Integer;
   Num_Joints : Integer;
   Num_Loads : Integer;
   Pin_Joint_Number : Integer;
   Roller_Joint_Number : Integer;
   Roller_Joint_Direction : Direction;
begin
   Truss_Input(Joints => Joints, Loads => Loads, Num_Loads => Num_Loads, Num_Bars => Num_Bars, Num_Joints => Num_Joints, Pin_Joint_Number => Pin_Joint_Number, Roller_Joint_Number => Roller_Joint_Number, Roller_Joint_Direction => Roller_Joint_Direction);
   Force_Set_Up(Num_Joints => Num_Joints, Num_Bars => Num_Bars, Joints => Joints, Forces => Forces, Pin_Joint_Number => Pin_Joint_Number, Roller_Joint_Number => Roller_Joint_Number, Roller_Joint_Direction => Roller_Joint_Direction);
   Solve_Forces(Forces => Forces, Num_Bars => Num_Bars, Num_Joints => Num_Joints, Loads => Loads, Num_Loads => Num_Loads);
   Truss_Output(Forces=> Forces, Num_Bars => Num_Bars);
end Solve_My_Truss;
