with Ada.Text_Io;
use Ada.Text_Io;
with Ada.Float_Text_Io;
use Ada.Float_Text_Io;
with Ada.Integer_Text_Io;
use Ada.Integer_Text_Io;
with Ada.Numerics.Elementary_Functions;
use Ada.Numerics.Elementary_Functions;
with Ada.Numerics;
use Ada.Numerics;
with Generic_Real_Arrays;
with Generic_Real_Arrays.Operations;


package body Truss is
   --package to solve statically determinate trusses
   --written by Howard Kleinwaks
   --last modified: 10/12/2003
   procedure Truss_Input (
         Joints                 :    out Jointarray; 
         Loads                  :    out Loadarray;  
         Num_Loads              :    out Integer;    
         Num_Bars               :    out Integer;    
         Num_Joints             :    out Integer;    
         Pin_Joint_Number       :    out Integer;    
         Roller_Joint_Number    :    out Integer;    
         Roller_Joint_Direction :    out Direction   ) is 
      --this procedure takes the input from the input file and then sets up the parameters to be
      --used in the rest of the program
      Temp             : Integer; 
      --file to read input from
      Truss_Input_File : File_Type; 
      --package to be able to do IO on direction type
      package Direction_Io is new Ada.Text_Io.Enumeration_Io(Enum => Direction);

   begin --Truss_Input
      --initialize bar array for each joint to be zero
      for I in 1..Max_Joints loop
         for J in 1..Max_Connections loop
            Joints(I).Bar_Array(J) := 0;
         end loop;
      end loop;
      
      --open file and get variables
      Open(
         File => Truss_Input_File, 
         Mode => In_File,          
         Name => "Truss_Input.txt");
      Get(
         File => Truss_Input_File, 
         Item => Num_Joints);
      --loop to get the joints
      for I in 1..Num_Joints loop
         Get(
            File => Truss_Input_File,     
            Item => Joints (I).Location.X);
         Get(
            File => Truss_Input_File,     
            Item => Joints (I).Location.Y);
         Get(
            File => Truss_Input_File,           
            Item => Joints (I).Num_Connect_Bars);
            --after number of bars is known, need to fill out which bars connect to the joint
         for J in 1..Joints(I).Num_Connect_Bars loop
            Get(
               File => Truss_Input_File, 
               Item => Temp);
            --if a joint connects, set the value in the bar array, at the position of the 
            --joint to 1.  For example, if you are at joint 1, and joint 2 connects to it
            -- then Joints(1).Bar_Array(2) = 1.
            Joints(I).Bar_Array(Temp) := 1;
            Temp := 0;
         end loop;
         for K in 1..Max_Connections loop
            --if the position in the bar array does not connect to the joint, set it to -1
            if (Joints(I).Bar_Array(K) /= 1) then
               Joints(I).Bar_Array(K) := -1;
            end if;
         end loop;
      end loop;

      --enter number of bars
      Get(
         File => Truss_Input_File, 
         Item => Num_Bars);
      --enter supports
      Get(
         File => Truss_Input_File, 
         Item => Pin_Joint_Number);
      Get(
         File => Truss_Input_File,   
         Item => Roller_Joint_Number);
         --enter direction of reaction force
      Direction_Io.Get(
         File => Truss_Input_File,      
         Item => Roller_Joint_Direction);
      Get(
         File => Truss_Input_File, 
         Item => Num_Loads);
         --Input Load - loop as many times as necessary
      for I in 1..Num_Loads loop
         Get(
            File => Truss_Input_File, 
            Item => Loads (I).Joint);
         Get(
            File => Truss_Input_File, 
            Item => Loads (I).Mag);
         Get(
            File => Truss_Input_File, 
            Item => Loads (I).Angle);
      end loop;

   end Truss_Input;

   procedure Force_Set_Up (
         Num_Joints             : in     Integer;    
         Num_Bars               : in     Integer;    
         Joints                 : in     Jointarray; 
         Forces                 :    out Forcearray; 
         Pin_Joint_Number       : in     Integer;    
         Roller_Joint_Number    : in     Integer;    
         Roller_Joint_Direction : in     Direction   ) is 
      --this procedure sets up the array of forces by setting every element in the 
      --record representing a force except for the magnitude of the force itself
      
      Count : Integer;  
      Xtan  : Float;  
      Ytan  : Float;  
   begin -- Force_Set_Up
      Count := 1;
      --loop through the joints, finding all the bars (known by which joints connect)
      --each time a bar is found, set joint1 and joint2 to the two end joints, and then calculate
      --the angle
      --use separate counter (Count) to keep track of the number of forces
      for I in 1..Num_Joints loop
         --loop through Joints twice, second time from I to the end so that we don't duplicate forces
         for J in I..Num_Joints loop
            if Joints(I).Bar_Array(J) /= -1 then
               --if the Joint you're at (I) has a connection to this joint (J) (the value in the
               --bar array is not -1) then set the joint you're at (I) to the Joint1 of the 
               --force record and set the connecting joint (J) to Joint 2
               Forces(Count).Joint1 := I;
               Forces(Count).Joint2 := J;
               --to get the angle from I to J (1 to 2), do I-J, and then take the inverse tangent
               Xtan := Joints(I).Location.X - Joints(J).Location.X;
               Ytan := Joints(I).Location.Y - Joints(J).Location.Y;
               --check to deal with horizontal and vertical bars
               if Xtan = 0.0 then
                  if Ytan < 0.0 then
                     Forces(Count).Angle_1_2 := -Pi/2.0;
                     Forces(Count).Angle_2_1 := Pi/2.0;
                  else
                     Forces(Count).Angle_1_2 := Pi/2.0;
                     Forces(Count).Angle_2_1 := -Pi/2.0;
                  end if;
               elsif Ytan = 0.0 then
                  if Xtan < 0.0 then
                     Forces(Count).Angle_1_2 := Pi;
                     Forces(Count).Angle_2_1 := 0.0;
                  else
                     Forces(Count).Angle_1_2 := 0.0;
                     Forces(Count).Angle_2_1 := Pi;
                  end if;
               else
                  --if bar is not horizontal or vertical, use the arctan function to find the angle
                  Forces(Count).Angle_1_2 := Arctan(Ytan, Xtan);
                  --to get the angle from J to I, do J-I
                  --don't have to check for horizontal and vertical bars again, since we set
                  --both angles above for those cases
                  Xtan := Joints(J).Location.X - Joints(I).Location.X;
                  Ytan := Joints(J).Location.Y - Joints(I).Location.Y;
                  Forces(Count).Angle_2_1 := Arctan(Ytan, Xtan);
               end if;
               --increment count to put the next force in the array
               Count := Count + 1;
            end if;
         end loop;
         --add in reaction forces to end of force array
         --we know the number of bars from the input, so add the reaction forces to the spots
         --in the array after all the bar forces (Num_Bars + 1, Num_Bars + 2, Num_Bars + 3)
         if I = Pin_Joint_Number then
            --x-reaction force at pin joint
            Forces(Num_Bars+1).Joint1 := I;
            Forces(Num_Bars+1).Joint2 := I;
            Forces(Num_Bars+1).Angle_1_2 := Pi;
            Forces(Num_Bars+1).Angle_2_1 := Pi;
            -- y-reaction force at pin joint
            Forces(Num_Bars+2).Joint1 := I;
            Forces(Num_Bars+2).Joint2 := I;
            Forces(Num_Bars+2).Angle_1_2 := -Pi/2.0;
            Forces(Num_Bars+2).Angle_2_1 := -Pi/2.0;
         elsif I = Roller_Joint_Number then
            Forces(Num_Bars+3).Joint1 := I;
            Forces(Num_Bars+3).Joint2 := I;
            --make sure of direction for roller joint
            if Roller_Joint_Direction = Horiz then
               Forces(Num_Bars+3).Angle_1_2 := Pi;
               Forces(Num_Bars+3).Angle_2_1 := Pi;
            elsif Roller_Joint_Direction = Vert then
               Forces(Num_Bars+3).Angle_1_2 := -Pi/2.0;
               Forces(Num_Bars+3).Angle_2_1 := -Pi/2.0;
            end if;
         end if;
      end loop;
   end Force_Set_Up;

   --THIS IS THE PROCEDURE YOU NEED TO CODE!!!
   procedure Solve_Forces (
         Forces     : in out Forcearray; 
         Num_Bars   : in     Integer;    
         Num_Joints : in     Integer;    
         Loads      : in     Loadarray;  
         Num_Loads  : in     Integer     ) is 
      --set up matrix packages


      --declare variables


   begin --solve_forces
      --initialize load vector
     --<code>
      -- set up matrix for forces
      --<code>
      --store all coefficients of forces in a matrix, then, 
      --by inverting the matrix, we can solve for the forces
      --we need to progress properly through the matrix 
      -- use nested loops (I and J)
      --first loop through joints (I)
         --<code>
         --reset the column counter
         
      --then loop through bars +3 (J) to account for reaction forces
      -- as well as bar forces
      --set the entry in the matrix to the coefficient of the bar force
      --<code>
      --if there is no corresponding bar force, 
      --set value in matrix to zero
      --increase the counter representing the column that you are at 
      --so you can store the
      --next force from the joint that we are at (I)
      --<code>
      --set load vector to have values of the load at the proper spot
      -- in the vector
      --<code>
      --end J loop
         --increment the row counter variables
         --<code>
         --end I loop


      --can now solve for forces by inverting the matrix 
      --store inverse in a separate matrix

      --forces = inverse*load --store forces in a vector
      --<code>
      --now set values in array of force records (Forces(I).Force) to the results you obtained
      --<code>
   end Solve_Forces;
   

   procedure Truss_Output (
         Forces   : Forcearray; 
         Num_Bars : Integer     ) is 
   begin --Truss_Output
      --print out bar forces
      for I in 1..(Num_Bars) loop
         Put("The force in bar ");
         Put(Forces(I).Joint1, Width => 1);
         Put(Forces(I).Joint2, Width => 1);
         Put(" is ");
         Put(Forces(I).Force, Fore => 2, Aft => 2, Exp => 0);
         New_Line;
         New_Line;
      end loop;
      --print out reaction forces
      Put("The pin reaction force in the x-direction is ");
      Put(Forces(Num_Bars+1).Force, Fore => 2, Aft => 2, Exp => 0);
      New_Line;
      Put("The pin reaction force in the y-direction is ");
      Put(Forces(Num_Bars+2).Force, Fore => 2, Aft => 2, Exp => 0);
      New_Line;
      Put("The roller reaction force is ");
      Put(Forces(Num_Bars+3).Force, Fore => 2, Aft => 2, Exp => 0);
      New_Line;
   end Truss_Output;


end Truss;

   