function [MATERIAL,SATELLITECOST]=SATELLITE_COST()
%function SATELLITE_COST(MATERIAL,RiskFreeRate,Inflation,ProductionNumber,YEAR)

clc;
%*******INPUTS*******
MATERIAL.NAME={'AL','CRES'};                % NAME-Cell array
MATERIAL.COST=[2.5,1];                      % $/Kg FY-Year
MATERIAL.MASS.SINGLE_LAYER=[200,300];       % KG
MATERIAL.MASS.DOUBLE_LAYER=[150,250];       % KG
MATERIAL.MASS.PercentTotalMass=.3;          % Do Not Change
YEAR=2000;                                  
Inflation=.02;                              % No Need to Change
ProductionNumber=10;                        % Number of Units Desired-INTEGER

%**************************************************************************
%*********Asumptions

% Double Layer costs 10% more than a single layer material with equivalent mass
DoubleFactor=.1;
LearningCurveSlope.SingleLayer=.85;
LearningCurveSlope.DoubleLayer=.9;

for MATERIAL_INDEX=1:size(MATERIAL.NAME,2)
    SATELLITECOST.RTDE.SINGLE(MATERIAL_INDEX)=((2460+416*(MATERIAL.MASS.SINGLE_LAYER(MATERIAL_INDEX))^0.66)*10^3)*(1+Inflation)^(YEAR-1992);      %FY92->FY-YEAR
    
    SATELLITECOST.RTDE_ERROR.SINGLE(MATERIAL_INDEX)=(4773*10^3)*(1+Inflation)^(YEAR-1992) ;                                                       %FY92->FY-YEAR
    
    SATELLITECOST.Production.SINGLE(MATERIAL_INDEX)=((86*(MATERIAL.MASS.SINGLE_LAYER(MATERIAL_INDEX))^0.65)*10^3)*(1+Inflation)^(YEAR-1992);      %FY92->FY-YEAR
    
    SATELLITECOST.Production_ERROR.SINGLE(MATERIAL_INDEX)=(1247*10^3)*(1+Inflation)^(YEAR-1992);                                                  %FY92->FY-YEAR
    
    SATELLITECOST.SSCM7_4_TotalBusCost.SINGLE(MATERIAL_INDEX)=((1.47+.07*(MATERIAL.MASS.SINGLE_LAYER(MATERIAL_INDEX))*...
        log(MATERIAL.MASS.SINGLE_LAYER(MATERIAL_INDEX))^0.66)*10^6)*(1+Inflation)^(YEAR-1994) ;                                                   %FY94->FY-YEAR
    
    SATELLITECOST.SSCM7_4_ERROR.SINGLE(MATERIAL_INDEX)=(5.4*10^6)*(1+Inflation)^(YEAR-1994);                                                      %FY94->FY-YEAR
    
    MATERIAL.MASS.TotalSatelliteMassSingle=MATERIAL.MASS.SINGLE_LAYER/MATERIAL.MASS.PercentTotalMass;
    
    MATERIAL.MASS.TotalSatelliteMassDouble=MATERIAL.MASS.DOUBLE_LAYER/MATERIAL.MASS.PercentTotalMass;
        
    SATELLITECOST.RTDE.DOUBLE(MATERIAL_INDEX)=(1+DoubleFactor)*((2460+416*(MATERIAL.MASS.DOUBLE_LAYER(MATERIAL_INDEX))^0.66)*10^3)*(1+Inflation)^(YEAR-1992);      %FY92->FY-YEAR
    
    SATELLITECOST.RTDE_ERROR.DOUBLE(MATERIAL_INDEX)=(1+DoubleFactor)*(4773*10^3)*(1+Inflation)^(YEAR-1992);                                                        %FY92->FY-YEAR
    
    SATELLITECOST.Production.DOUBLE(MATERIAL_INDEX)=(1+DoubleFactor)*((86*(MATERIAL.MASS.DOUBLE_LAYER(MATERIAL_INDEX))^0.65)*10^3)*(1+Inflation)^(YEAR-1992);                      %FY92->FY-YEAR
    
    SATELLITECOST.Production_ERROR.DOUBLE(MATERIAL_INDEX)=(1+DoubleFactor)*(1247*10^3)*(1+Inflation)^(YEAR-1992);                                  %FY92->FY-YEAR
    
    SATELLITECOST.SSCM7_4_TotalBusCost.DOUBLE(MATERIAL_INDEX)=(1+DoubleFactor)*((1.47+.07*(MATERIAL.MASS.DOUBLE_LAYER(MATERIAL_INDEX))*...
        log(MATERIAL.MASS.DOUBLE_LAYER(MATERIAL_INDEX))^0.66)*10^6)*(1+Inflation)^(YEAR-1994);                                                                     %FY94->FY-YEAR
    
    SATELLITECOST.SSCM7_4_ERROR.DOUBLE(MATERIAL_INDEX)=(1+DoubleFactor)*(5.4*10^6)*(1+Inflation)^(YEAR-1994);                                                      %FY94->FY-YEAR
    
    
    
    for i=1:ProductionNumber
        %Single Layer
        p=(log10(LearningCurveSlope.SingleLayer)/log10(2));
        
        SATELLITECOST.AvgSystemCost.Single(MATERIAL_INDEX)=...
            (MATERIAL.MASS.SINGLE_LAYER(MATERIAL_INDEX)*MATERIAL.COST(MATERIAL_INDEX)+SATELLITECOST.RTDE.SINGLE(MATERIAL_INDEX)+...
            SATELLITECOST.Production.SINGLE(MATERIAL_INDEX))*ProductionNumber^p/(1+p);
        
        SATELLITECOST.AvgSystemCost_SSCM7_4.Single(MATERIAL_INDEX)=(MATERIAL.MASS.SINGLE_LAYER(MATERIAL_INDEX)*MATERIAL.COST(MATERIAL_INDEX)...
            +SATELLITECOST.SSCM7_4_TotalBusCost.SINGLE(MATERIAL_INDEX))*ProductionNumber^p/(1+p);
        
        SATELLITECOST.UnitCosts.SINGLE(MATERIAL_INDEX,i)=(SATELLITECOST.RTDE.SINGLE(MATERIAL_INDEX)+SATELLITECOST.Production.SINGLE(MATERIAL_INDEX))*i^p;
        
        SATELLITECOST.UnitCosts_SSCM7_4.SINGLE(MATERIAL_INDEX,i)=SATELLITECOST.SSCM7_4_TotalBusCost.SINGLE(MATERIAL_INDEX)*i^p;
    
        %Double Layer
        p=(log10(LearningCurveSlope.DoubleLayer)/log10(2));
        
        SATELLITECOST.AvgSystemCost.Double(MATERIAL_INDEX)=...
            (MATERIAL.MASS.DOUBLE_LAYER(MATERIAL_INDEX)*MATERIAL.COST(MATERIAL_INDEX)+SATELLITECOST.RTDE.DOUBLE(MATERIAL_INDEX)+...
            SATELLITECOST.Production.DOUBLE(MATERIAL_INDEX))*ProductionNumber^p/(1+p);
        
        SATELLITECOST.AvgSystemCost_SSCM7_4.Double(MATERIAL_INDEX)=(MATERIAL.MASS.DOUBLE_LAYER(MATERIAL_INDEX)*MATERIAL.COST(MATERIAL_INDEX)+...
            SATELLITECOST.SSCM7_4_TotalBusCost.DOUBLE(MATERIAL_INDEX))*ProductionNumber^p/(1+p);
        
        SATELLITECOST.UnitCosts.DOUBLE(MATERIAL_INDEX,i)=(SATELLITECOST.RTDE.DOUBLE(MATERIAL_INDEX)+SATELLITECOST.Production.DOUBLE(MATERIAL_INDEX))*i^p;
        
        SATELLITECOST.UnitCosts_SSCM7_4.DOUBLE(MATERIAL_INDEX,i)=SATELLITECOST.SSCM7_4_TotalBusCost.DOUBLE(MATERIAL_INDEX)*i^p;
    end

end


