%This is the main file of the program.  It lists the material data and calls all functions

%Here are the constants********WE MAY WANT TO INCLUDE SOME OF THEM AS INPUTS*******

%CONSTANTS*******NEED TO BE DETERMINED
Tspace      =   1000;               %Value of temperature on outside surface in Kelvin
P           =   127500;         %load N
%M           =                   %Moment Nm
%SF_yield    =                   %Can be taken from SMAD 
%SF_ultimate =                   %
altitude    = 700e3;                  %m
Q_w         = 170;                  %Watts
%Volume      =                   %m^3
T_user_max  = 35;                  %Kelvin
T_user_min  = 5;                  %Kelvin
YEAR        =   2000;                                  
Inflation   =   .02;            % No Need to Change
ProductionNumber    =   10;     % Number of Units Desired-INTEGER
%RiskFreeRate        =   ;

%The metal (material) names and properties are listed below.  More can be added to this list and would be accounted for in the code
%The properties below are approximate and taken from the following refrences
%Reference 1:  Thermophysical Properties of Selected Aerospace Materials Part I:  Thermal Radiative Properties Y.S. Touloukian and C.Y. Ho
%ref1 contd: 1976 Purdue Research West Layfette Ind. 47907
%Reference 2:  American Society for Metals.  Metals Handbook, Metals Park, Ohio 44073 Edit by Howard E. Boyer, Timothy L. Gall, 1985
%Reference 3:  ASM metals Reference Book 2nd edition 1983
%Reference 4:  Radiative Properties of MAterials, Aleksander Sala, Elsevier Science Publishers NY,NY 10017, 1986
%Reference 5: Metals Handbook 9th edition vol. 2 Properties and selection of nonferrous alloys and pure metals,1979, ASM
%Reference 6: (for the graphite structural data) www.me.poly.edu/hk/subject/me262/notes/chapt9.pdf

metal.name={'Aluminum Alloy 2024 T4';'Austenitic Stainless Steal 304';'Titanium Alloy Ti-6Al-4V';'Gold';'Graphite Epoxy'};
   
metal.density(1,1)    =   2.795; %g/cm^3
metal.density(2,1)    =   7.9; %g/cm^3
metal.density(3,1)    =   4.4; %g/cm^3 
metal.density(4,1)    =   1.8; %g/cm^3
metal.density(5,1)    =   2.42; %g/cm^3

metal.emmisivity_temp(1,:)   =   [250,350,450,550,650,750];
metal.emmisivity_temp(2,:)   =   [300,600,900,1200,1500,1700];
metal.emmisivity_temp(3,:)   =   [400,500,600,700,800,850];
metal.emmisivity_temp(4,:)   =   [250,500,750,1000,1125,1250];
metal.emmisivity_temp(5,:)   =   [250,300,350,400,450,500];
    
metal.emmisivity_value(1,:) =   [.030,.036,.040,.043,.046,.048];
metal.emmisivity_value(2,:) =   [.138,.154,.170,.186,.202,.212];
metal.emmisivity_value(3,:) =   [.151,.162,.174,.187,.202,.210];
metal.emmisivity_value(4,:) =   [.019,.021,.023,.026,.028,.029];
metal.emmisivity_value(5,:) =   [.888,.888,.888,.888,.888,.888];
   
metal.absorb_temp(1,:)  =   [250,3500,450,550,650,750];
metal.absorb_temp(2,:)  =   [300,600,900,1200,1500,1700];
metal.absorb_temp(3,:)  =   [300,400,500,600,700,800];
metal.absorb_temp(4,:)  =   [250,500,750,1000,1125,1250];
metal.absorb_temp(5,:)  =   [250,300,350,400,450,500];

metal.absorb_value(1,:) =   [.030,.036,.040,.043,.046,.048];
metal.absorb_value(2,:) =   [.138,.154,.170,.186,.202,.212];
metal.absorb_value(3,:) =   [.136,.138,.140,.141,.142,.142];
metal.absorb_value(4,:) =   [.300,.300,.300,.300,.300,.300];
metal.absorb_value(5,:) =   [.888,.888,.888,.888,.888,.888];

metal.tensile_strength(1,1)  =   470e6;  %Pa
metal.tensile_strength(2,1)  =   515e6;  %Pa
metal.tensile_strength(3,1)  =   993e6;  %Pa
metal.tensile_strength(4,1)  =   130e6;  %Pa
metal.tensile_strength(5,1)  =   2000e6;  %Pa

metal.yield_strength(1,1)   =   325e6; %Pa
metal.yield_strength(2,1)   =   205e6; %Pa
metal.yield_strength(3,1)   =   924e6; %Pa
metal.yield_strength(4,1)   =   16e6; %Pa
metal.yield_strength(5,1)   =   1750e5; %Pa

metal.Young(1,1)    =   72.4e9; %Pa
metal.Young(2,1)    =   193e9;  %Pa
metal.Young(3,1)    =   113.8e9; %Pa
metal.Young(4,1)    =   79.9e9;  %Pa  
metal.Young(5,1)    =   110e9; %Pa
   
    %Determine the number of metal considered.
    num =   length(metal.density);
    
    %For each metal considered, determine the emmisivity and absorbitivity at the temperature Tspace
    %Since both emmisivity and absorbtivity are functions of temperature, linear interpolation/exterpolation is performed for the range given
    for i=1:num
        %If Tspace is within the data values, perform linear interpolation for emmisivity
        if(Tspace>=min(metal.emmisivity_temp(i,:)) & Tspace<=max(metal.emmisivity_temp(i,:)))
            index_min(i)   =   max(find(Tspace>=metal.emmisivity_temp(i,:)));
            index_max(i)    =   min(find(Tspace<metal.emmisivity_temp(i,:)));
        end
        %If it is below or above, perform exterpolation for emmisivity
        if(Tspace<min(metal.emmisivity_temp(i,:)))
            index_min(i)    =   1;
            index_max(i)    =   2;
        end
        if(Tspace>max(metal.emmisivity_temp(i,:)))
            index_min(i)    =   length(metal.emmisivity_temp(i,:))-1;
            index_max(i)    =   length(metal.emmisivity_temp(i,:));
        end

        %Find the correspoinding values of temperature and emmisivity for the given indices
        etempmin(i) =   metal.emmisivity_temp(i,index_min(i));
        etempmax(i) =   metal.emmisivity_temp(i,index_max(i));
        emin(i)    =   metal.emmisivity_value(i,index_min(i));
        emax(i)     =   metal.emmisivity_value(i,index_max(i));
        
        %Perform the interpolation/exterpolation to determine the emmisivity for the given metal if the value changes with temperature
    
        metal.emmisivity(i) =  emin(i)+ (Tspace- etempmin(i))/(etempmax(i) - etempmin(i)) *(emax(i)-emin(i));
      
        %If Tspace is within the data values, perform linear interpolation for absorbtivity
        if(Tspace>=min(metal.absorb_temp(i,:)) & Tspace<=max(metal.absorb_temp(i,:)))
            index_min(i)   =   max(find(Tspace>=metal.absorb_temp(i,:)));
            index_max(i)    =   min(find(Tspace<metal.absorb_temp(i,:)));
        end
        %If it is below or above, perform exterpolation for absorb
        if(Tspace<min(metal.absorb_temp(i,:)))
            index_min(i)    =   1;
            index_max(i)    =   2;
        end
        if(Tspace>max(metal.absorb_temp(i,:)))
            index_min(i)    =   length(metal.absorb_temp(i,:))-1;
            index_max(i)    =   length(metal.absorb_temp(i,:));
        end
        atempmin(i) =   metal.absorb_temp(i,index_min(i));
        atempmax(i) =   metal.absorb_temp(i,index_max(i));
        amin(i)     =   metal.absorb_value(i,index_min(i));
        amax(i)     =   metal.absorb_value(i,index_max(i));
        
        %Perform the interpolation/exterpolation to determine the absorb for the given metal
        metal.absorb(i) =  amin(i)+ (Tspace- atempmin(i))/(atempmax(i) - atempmin(i)) *(amax(i)-amin(i));
    
    end

   if 0,
       %Assume that the inner layer provides the structure, but the outer layer provides the thermal protection
       for i = 1:num
           for(j=1:num)
               if(i==j)
                   %If there is only one layer, it must provide the sturcutre and thermal protection
                   thickness(i,j)    =   strength(P,M,rad,SF_ultimate,SF_yield,metal.tensile_strength(i),metal.yield_strength(i),metal.Young(i));
                    V_interior(i,j) = ((4/3)*pi*(rad-thickness(i,j))^3);
                    %Feasible determines if the design determined by the strength codes is feasible from a thermal standpoint
                    feasible = thermal(metal.absorb(i), metal.emmisivity(i), T_user_max, T_user_min, V_interior(i), thickness(i), altitude, Q_w);
                    %Still don't know what to do with THIS*&***
                    if feasible == 1
                        %Now we must compute the mass
                        mass(i,j)   =   metal.density(i)*(Volume - ((4/3)*pi*(rad-thickness(i,j))^3));
                    else
                        mass(i,j) = -1;
                    end
                end
                if(j~=i)
                    %If there are two layers, the inner holds the structure, while the outer provides the thermal protection
                    %The thickness of the outer layer is determined to be 5 percent of the inner layer
                    tinner(i,j)   =   strength(P,M,rad,SF_ultimate,SF_yield,metal.tensile_strength(j),metal.yield_strength(j),metal.Young(j));
                    touter(i,j)   =     .05*tinner(i,j);
                    thickness(i,j)  =   tinner(i,j)+touter(i,j);  %****OR SHOULD THIS JUST BE TOUTER???????
                    %Calculate interior volume
                    V_interior(i,j) = ((4/3)*pi*(rad-thickness(i,j))^3);
                
                    %The emmisivity and the absorbtivity are just the values of the outer sheel
                    feasible = thermal(metal.absorb(i), metal.emmisivity(i), T_user_max, T_user_min, V_interior(i,j), thickness(i,j), altitude, Q_w);
                %****WHAT SHOULD WE DO IF IT IS OR IS NOT FEASIBLE?????********
                    if feasible == 1
                        mouter(i,j)  =   metal.density(i)*(Volume - (4/3)*pi(rad-touter(i,j))^3);
                        minner(i,j) =   metal.density(j)*((4/3)*pi(rad-touter(i,j))^3 - (4/3)*pi(rad-touter(i,j)-tinner(i,j))^3);
                        mass(i,j)   =   mouter(i,j)+minner(i,j);
                    else
                        mass(i,j) = -1;
                    end

            end
        end
    end
end

                    
    %Determine the thickness of the shell (for one or two layers), calculate if the shell is feasible from a thermal standpoint and then calculate the mass
    for i= 1:num
        for (j=1:num)
            if(j==i)
                %Treat as one layer
                %Determine the thickness required for a single layer
                thickness(i,j)    =   strength(P,M,rad,SF_ultimate,SF_yield,metal.tensile_strength(i),metal.yield_strength(i),metal.Young(i));
                %Calculate interior volume
                V_interior(i,j) = ((4/3)*pi*(rad-thickness(i,j))^3);
                %Feasible determines if the design determined by the strength codes is feasible from a thermal standpoint
                feasible = thermal(metal.absorb(i), metal.emmisivity(i), T_user_max, T_user_min, V_interior(i), thickness(i), altitude, Q_w);
                %****WHAT SHOULD WE DO IF IT IS OR IS NOT FEASIBLE?????********  
                if feasible == 1
                    %Now we must compute the mass
                    mass(i,j)   =   metal.density(i)*(Volume - ((4/3)*pi*(rad-thickness(i,j))^3));
                else
                    mass(i,j) = -1;
                end
            end
            if(j~=i)
                %Treat as two layers
                touter(i,j)   =   strength(P/2,M/2,rad,SF_ultimate,SF_yield,metal.tensile_strength(i),metal.yield_strength(i),metal.Young(i));
                tinner(i,j)   =   strength(P/2,M/2,rad,SF_ultimate,SF_yield,metal.tensile_strength(j),metal.yield_strength(j),metal.Young(j));
                thickness(i,j)  =   touter(i,j)+tinner(i,j);
                
                %Calculate interior volume
                V_interior(i,j) = ((4/3)*pi*(rad-thickness(i,j))^3);
                %Determine the effective emmisivity by a percentage of thickness of the material
                emmisivity_effective    =   touter(i,j)/thickness(i,j)*metal.emmisivity(i) + tinner(i,j)/thickness(i,j)*metal.emmisivity(j);
                %Determine the effective absorbtivity by a percentage of thickness of the material
                absorb_effective    =   touter(i,j)/thickness(i,j)*metal.absorb(i) + tinner(i,j)/thickness(i,j)*metal.absorb(j);
                %Feasible determines if the design determined by the strength codes is feasible from a thermal standpoint
                %For a two layer structure, we use the effective absorbtivity and emmisivity to determin if the structure is feasible
                feasible = thermal(absorb_effective, emmisivity_effective, T_user_max, T_user_min, V_interior(i,j), thickness(i,j), altitude, Q_w);
                %****WHAT SHOULD WE DO IF IT IS OR IS NOT FEASIBLE?????********
                if feasible == 1
                    mouter(i,j)  =   metal.density(i)*(Volume - (4/3)*pi(rad-touter(i,j))^3);
                    minner(i,j) =   metal.density(j)*((4/3)*pi(rad-touter(i,j))^3 - (4/3)*pi(rad-touter(i,j)-tinner(i,j))^3);
                    mass(i,j)   =   mouter(i,j)+minner(i,j);
                else
                    mass(i,j) = -1;
                end

            end
        end
    end
    
    
    
    %Now we must determine Cost
   %function [MATERIAL,SATELLITECOST]= SATELLITE_COST(MATERIAL,RiskFreeRate,Inflation,ProductionNumber,YEAR)

%*******INPUTS*******
MATERIAL.NAME={'AL','CRES'};                % NAME-Cell array
MATERIAL.COST=[2.5,1];                      % $/Kg FY-Year
MATERIAL.MASS.SINGLE_LAYER=[200,300];       % KG
MATERIAL.MASS.DOUBLE_LAYER=[150,250];       % KG
MATERIAL.MASS.PercentTotalMass=.3;          % Do Not Change
YEAR=2000;                                  
Inflation=.02;                              % No Need to Change
ProductionNumber=10;                        % Number of Units Desired-INTEGER

%**************************************************************************
%*********Asumptions