function [t]    =   strength(P,M,rad,SF_ultimate,SF_yield,Tensile_strength,Yield_strength,Young)



%This function inputs P, which is the load applied in Newtons, and M, the Moment applied in N-m.  In addition, the radius, rad of the sphere 
%must be defined.  %Also, the safety factor for the structure needs to be given.  For help choosing a safety factor, SMAD pg 468, table 11-54
%gives a guide.  Both the ultimate safety factor and the yield safety factor should be provided

%Rigity due to both axial and lateral frequencies is neglected
%Ignoring stress due to internal pressure
%For a sphere, all is symmetric and the axial load equals the lateral load, which equals the load and is therefore referred to only as a load
%The bending will be assume to act at the furthest distance for the worst case (radii)

%The equations to determine the thickness are taken from SMAD pg 488  
%We first size for tensile strength and then check the thickness agains a compressive load
%In order to size for strength the effective load, including safety factor must be determined equation 11-51

Load_limit  =   P + 2*M/rad;

%Determine the ultimate load
Ultimate_load   =   Load_limit*SF_ultimate;

%Size the thickness of the material to withstand the ultimate load
%Approximating cross-sectional area as 2*pi*rad*thickness
t_ultimate  =   Ultimate_load/(2*pi*rad*Tensile_strength);

%Determine the yield load
Yield_load  =   Load_limit*SF_yield;

%Determine the thickness of the material to withstand the yield load

t_yield =   Yield_load/(2*pi*Yield_strength);

%The maximum value of the thickness, is the thickness of the material
t   =   max(t_ultimate,t_yield);

%Now, we determine if this thickness can withstand the necessary compressive forces SMAD pg480 eq. 11-52-11-54
phi =   (1/16)*sqrt(rad/t);
gamma   =   1-.901*(1-exp(-phi));

%Determine buckling stress and buckling load
%The area here is the actual cross-sectional area of the center of the sphere. 
%This is the worst case scenario since the area is greatest and therefore the buckling force is greatest
buckle  =   .6*gamma*Young/rad;
P_buckle    =   buckle*2*pi*(rad^2 - (rad-t)^2);


%Determine if the thickness is enough.  Loop through, increasing the thickness until the buckling load (the load it can withstand) is greater than
%the ultimate load with safety factor included (the load it needs to withstand...within a factor of safety)
while(P_buckle/Ultimate_load < 1)
    t = 1.025*t;
    %Now, we determine if this thickness can withstand the necessary compressive forces SMAD pg480 eq. 11-52-11-54
    phi =   (1/16)*sqrt(rad/t);
    gamma   =   1-.901*(1-exp(-phi));

    %Determine buckling stress and buckling load
    %The area here is the actual cross-sectional area of the center of the sphere. 
    %This is the worst case scenario since the area is greatest and therefore the buckling force is greatest
    buckle  =   .6*gamma*Young/rad;
    P_buckle    =   buckle*2*pi*(rad^2 - (rad-t)^2);
end

