% Christopher Hynes
% 16.851 Satellite Engineering
% Problem Set 5
%
% Space Hotel Cost Software Module
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%
% years  = number of years in operation
% n_crew = Number of people staying on board the space hotel at any time
% duration  = Duration of stay for guests of the space hotel (days)
% w_f = weight of structure (kgs)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% OUTPUTS
%
% total_cost = amount (dollars) of total investment required for
% construction, logistics, and operation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function total_cost = cost_model(years, n_crew, duration, w_f)

%Please see paper for explanations
s_cf = 104e3; %space segment cost factor [$/kg]
p_cf = 1.0; %
r_cf = 2.0; % research and development cost factor

s_c = s_cf*p_cf*r_cf; %space cost

l_cf = 15.2e3; %launch cost factor
i_cf = 1.33; %insurance cost factor

l_c = l_cf*i_cf*w_f; %launch cost

y_osc = 80e6; %yearly operation cost

delta_cs = 2000; %crew support specific weight [kg/person]
delta_crew = 170; %crew specific weight [kg/person]
delta_gear = 72; %crew specific gear weight [kg/person]

consumption_rate = 9.453515; %rate of consumption [kg/person]

w_cl = 365*((delta_cs + delta_crew + delta_gear)*(n_crew/duration) + consumption_rate*n_crew);  %yearly crew logistics weight

m_mf = 0.01; %maintenance materials weight fraction

w_mm = w_f*m_mf; %materials yearly delivery weight

w_l = w_cl + w_mm; %logistics weight
l_gc = l_cf*i_cf*w_l; %logistics cost (per year)

o_sc = years*(y_osc + l_gc);  % operational cost

total_cost = s_c + l_c + o_sc;
