% Christopher Hynes
% 16.851 Satellite Engineering
% Problem Set 5
%
% Space Hotel Cost Software Module
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%
% years  = number of years in operation
% n_crew = Number of people staying on board the space hotel at any time
% duration  = Duration of stay for guests of the space hotel (days)
% w_f = weight of structure (kgs)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% OUTPUTS
%
% total_cost = amount (dollars) of total investment required for
% construction, logistics, and operation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function total_cost = cost_model(years, n_crew, duration, w_f)

N_guests_min = 20;
N_guests_max = 100;
duration_min = 30;
duration_max = 180;

cost_matrix = zeros(N_guests_max - N_guests_min + 1, duration_max - duration_min + 1);

for N_guests = N_guests_min:N_guests_max
    for duration = duration_min:duration_max
        
        [str_mass,spin_rate] = structure(N_guests, duration);
        total_cost = cost_model(10, N_guests, duration, str_mass);
        cost_matrix(N_guests - N_guests_min + 1,duration - duration_min + 1) = total_cost;
    end
end

figure(1)
for i = 1:duration - duration_min + 1
    hold on
    duration = duration_min + i;
    if duration < 30
        plot([N_guests_min:N_guests_max],cost_matrix(:,i),'k*');
    elseif duration >= 30 && duration < 50
        plot([N_guests_min:N_guests_max],cost_matrix(:,i),'b*');
    elseif duration >=50 && duration < 70
        plot([N_guests_min:N_guests_max],cost_matrix(:,i),'r*');
    elseif duration >=70 && duration < 90
        plot([N_guests_min:N_guests_max],cost_matrix(:,i),'m*');
    elseif duration >= 90 && duration < 110
        plot([N_guests_min:N_guests_max],cost_matrix(:,i),'g*');
    elseif duration >= 110 && duration < 130
        plot([N_guests_min:N_guests_max],cost_matrix(:,i),'c*');
    elseif duration >= 130 && duration <= 150
        plot([N_guests_min:N_guests_max],cost_matrix(:,i),'y*');
    elseif duration >= 150 && duration <= 170
        plot([N_guests_min:N_guests_max],cost_matrix(:,i),'b*');
    end
end
ylabel('Cost ($)')
xlabel('Number of Hotel Guests')

