function T_max = compute_communication_time(D_max,R_min)
% T_max = compute_communication_time(D_max,R_min)
%   This module assume communication initiation time of 2 min and adds in a
%   margin of 3 to the quantity of data.
%
%   Ref: Wertz and Larson. Space Misson Analysis and Design, 2nd ed.
%
% Input
%   D_max           Maximum quantity of Data [bit]
%   R_min           Minimum data transfer rate [bit/sec]
% Output
%   T_max           Maximum required communication time [sec]

% Communication initation time [sec]
T_initiate = 2*60;

% Margin to account for missed passes
M = 3;

% From SMAD 3rd ed.
T_max = (D_max*M/R_min + T_initiate);

