clear;
close all;

R_E         = 6378136.49;               % Earth equatorial radius [m]
data_max    = 8000000;                  % maximum data [bits]
rate_min    = 96000;                    % minimum data transfer rate [bps]
epsilon_min = 5*pi/180;                 % minimum satelite elevation from surface [rad]
lat_gs      = 0:10*pi/180:50*pi/180;    % latitude of the ground station [rad]

% Minimum communication time per fly-by [sec]
T_min = compute_communication_time(data_max, rate_min);

% Compute feasible orbits and the corresponding maximum distance.
for i=1:length(lat_gs)
    [r{i},i_max{i},D_max{i}] = compute_feasible_circular_LEO(T_min,epsilon_min,lat_gs(i));
end

figure(1)
plot(r{1}/R_E,i_max{1}*180/pi,r{2}/R_E,i_max{2}*180/pi,r{3}/R_E,i_max{3}*180/pi,r{4}/R_E,i_max{4}*180/pi,r{5}/R_E,i_max{5}*180/pi,r{6}/R_E,i_max{6}*180/pi);
axis([1 1.8 0 70])
ylabel('Maximum Inclination Angle [deg]')
xlabel('Orbit Radius[R_E]')
legend('0^o','10^o','20^o','30^o','40^o','50^o',2)
figure(2)
plot(r{1}/R_E,D_max{1}/R_E);
ylabel('Maximum Distance from the Ground Station [R_E]')
xlabel('Orbit Radius[R_E]')
