clear;
close all;

R_E         = 6378136.49;               % Earth equatorial radius [m]
data_max    = 8000000;                  % maximum data [bits]
rate_min    = 96000;                    % minimum data transfer rate [bps]
epsilon_min = 5*pi/180;                 % minimum satelite elevation from surface [rad]
lat_gs      = 42*pi/180;                % latitude of the ground station [rad]

% Minimum communication time per fly-by [sec]
T_min = compute_communication_time(data_max, rate_min);

% Compute feasible orbits and the corresponding maximum distance.
[r,i_max,D_max] = compute_feasible_circular_LEO(T_min,epsilon_min,lat_gs);

figure(1)
plot(r/R_E,180 - i_max*180/pi);
ylabel('Maximum Incident Angle [deg]')
xlabel('Orbit Radius[R_E]')
figure(2)
plot(r/R_E,D_max/R_E);
ylabel('Maximum Distance from the Ground Station [R_E]')
xlabel('Orbit Radius[R_E]')
