function bestveh = launcher_select(payload, veh_input);

% This is a launch vehicle selection tool
% input #1 - payload specifictions
% input #2 - launch vehicle specs


%expand database for upper stages
kk = 1;

for ii = [1:length(veh_input)]

  %## if generic vehicle can lift payload, add to database

  for jj = [1:length(veh_input{ii}.upper_stage)]
    veh{kk} = veh_input{ii};
    veh{kk}.class = [veh_input{ii}.class '_' veh_input{ii}.upper_stage{jj}.var_name];

		veh{kk}.mass2leo = veh_input{ii}.upper_stage{jj}.mass2leo;
		veh{kk}.mass2polar = veh_input{ii}.upper_stage{jj}.mass2polar;
		veh{kk}.mass2ss = veh_input{ii}.upper_stage{jj}.mass2SS;
		veh{kk}.mass2sunsync = veh_input{ii}.upper_stage{jj}.mass2sunsync;
		veh{kk}.mass2gto = veh_input{ii}.upper_stage{jj}.mass2gto;
		veh{kk}.mass2geo = veh_input{ii}.upper_stage{jj}.mass2geo;
		veh{kk}.cost = veh_input{ii}.upper_stage{jj}.cost;
		veh{kk}.fairingheight = veh_input{ii}.upper_stage{jj}.fairingheight;
		veh{kk}.fairingdiameter = veh_input{ii}.upper_stage{jj}.fairingdiameter;
        
        veh{kk} = rmfield(veh{kk}, 'upper_stage');
		kk = kk+1;
  end 


end


% filter based on all constraints
site_found = 0; %flag found
m = 1; %counter for qualified vehicles
for i = [1:length(veh)]
    %site and inclination constraint
    for j = [1:length(veh{i}.site)]
        if(veh{i}.site{j}.max_incl >= payload.inclination & veh{i}.site{j}.min_incl <= payload.inclination)
            site_found = 1;
        end
    end
    
    if(site_found == 0)
        continue;
    end
    
    %mass constraint
    if(strcmp(payload.orbit_type,'leo') == 1)
        if(veh{i}.mass2leo < payload.mass)
            continue;
        end
    end
    if(strcmp(payload.orbit_type,'gto') == 1)
        if(veh{i}.mass2gto < payload.mass)
            continue;
        end
    end
    if(strcmp(payload.orbit_type,'geo') == 1)
        if(veh{i}.mass2geo < payload.mass)
            continue;
        end
    end
    if(strcmp(payload.orbit_type,'polar') == 1)
        if(veh{i}.mass2polar < payload.mass)
            continue;
        end
    end
    if(strcmp(payload.orbit_type,'sunsync') == 1)
        if(veh{i}.mass2sunsync < payload.mass)
            continue;
        end
    end
    if(strcmp(payload.orbit_type,'ss') == 1)
        if(veh{i}.mass2ss < payload.mass)
            continue;
        end
    end
    %diameter constraint
    if(veh{i}.fairingdiameter < payload.diameter)
        continue;
    end
    %height constraint
    if(veh{i}.fairingheight < payload.height)
        continue;
    end
    %max_acceleration constraint
    if(payload.max_lat_accel ~= -1)
        if(veh{i}.max_lat_accel > payload.max_lat_accel)
            continue;
        end
    end
    %max_acceleration constraint
    if(payload.max_axial_accel ~= -1)
    if(veh{i}.max_axial_accel > payload.max_axial_accel)
        continue;
    end
end
    %vibration constraint
    if(payload.lat_freq ~= -1)
        if(veh{i}.min_lat_freq > payload.lat_freq)
            continue;
        end 
    end
    if(payload.long_freq ~= -1)
        if(veh{i}.min_long_freq > payload.long_freq)
            continue;
        end 
    end
    %acoustic constraint
    if(payload.acoustic ~= -1)
    if(veh{i}.acoustic > payload.acoustic)
        continue;
    end
end
    %temp constraint
    if(payload.max_aeroheating ~= -1)
    if(veh{i}.max_aeroheating > payload.max_aeroheating)
        continue;
    end
end
    %air_clean constraint
    if(payload.air_clean ~= -1)
        if(veh{i}.air_clean < payload.air_clean)
            continue;
        end
    end
    %orbit_accu
    if(payload.orbital_accu_alt ~= -1)
    if(veh{i}.orbital_accu_alt > payload.orbital_accu_alt)
        continue;
    end
end
    if(payload.orbital_accu_incl ~= -1)
    if(veh{i}.orbital_accu_incl > payload.orbital_accu_incl)
        continue;
    end
end
    
    %vehicle passes all constraints, add to list
    qualified_vehicles{m} = veh{i};
%     fprintf(['\n' qualified_vehicles{m}.class '\n'])
    m = m+1;
end

%calculate reliability
%calculate availiability for remaining vehicles
%calculate performance margin
if(exist('qualified_vehicles') == 0)
    error('  No Vehicles Qualify.');
end

for i = [1:length(qualified_vehicles)]
       if(qualified_vehicles{i}.total_flights == 0)
           qualified_vehicles{i}.reliability = 0;
       else
           qualified_vehicles{i}.reliability = qualified_vehicles{i}.success_flight/qualified_vehicles{i}.total_flights;
       end
       qualified_vehicles{i}.availiability = 1 - (payload.launchfreq*(1-qualified_vehicles{i}.reliability)*qualified_vehicles{i}.stddwntime/(1 - 1/qualified_vehicles{i}.surge));
    if(strcmp(payload.orbit_type,'leo') == 1)
        qualified_vehicles{i}.pmargin = qualified_vehicles{i}.mass2leo - payload.mass;
    end
    if(strcmp(payload.orbit_type,'gto') == 1)
        qualified_vehicles{i}.pmargin = qualified_vehicles{i}.mass2gto - payload.mass;
    end
    if(strcmp(payload.orbit_type,'geo') == 1)
        qualified_vehicles{i}.pmargin = qualified_vehicles{i}.mass2geo - payload.mass;
    end
    if(strcmp(payload.orbit_type, 'polar') == 1)
        qualified_vehicles{i}.pmargin = qualified_vehicles{i}.mass2polar - payload.mass;
    end
    if(strcmp(payload.orbit_type, 'sunsync') == 1)
        qualified_vehicles{i}.pmargin = qualified_vehicles{i}.mass2sunsync - payload.mass;
    end
    if(strcmp(payload.orbit_type, 'ss') == 1)
        qualified_vehicles{i}.pmargin = qualified_vehicles{i}.mass2ss - payload.mass;
    end
end

% now optimize based on options
m = 1;
if(payload.absolute_cost == 1)
    fprintf('\n## Absolute Cost Optimization ##\n')
    while(~isempty(qualified_vehicles))
        min = qualified_vehicles{1}.cost+((1 - qualified_vehicles{1}.reliability)*qualified_vehicles{1}.cost); 
        bestveh{m} = qualified_vehicles{1};
        bestveh{m}.abs_cost = min;
        
        best = 1;
        for i = [1:length(qualified_vehicles)]
            if(qualified_vehicles{i}.cost + ((1 - qualified_vehicles{i}.reliability)*qualified_vehicles{i}.cost) < min)
                bestveh{m} = qualified_vehicles{i};
                bestveh{m}.abs_cost = (qualified_vehicles{i}.cost + ((1 - qualified_vehicles{i}.reliability)*qualified_vehicles{i}.cost));
                min = qualified_vehicles{1}.cost+((1 - qualified_vehicles{1}.reliability)*qualified_vehicles{1}.cost);
                best = i;       
            end
        end
        %delete best entry from qualified vehicles
        fprintf(['\n   ' qualified_vehicles{best}.class ' | ' num2str(qualified_vehicles{best}.cost+((1 - qualified_vehicles{best}.reliability)*qualified_vehicles{best}.cost)) '\n'])
        qualified_vehicles(best) = [];
        m = m+1;
    end
end
if(payload.cost == 1)
    fprintf('\n## Cost Optimization ##\n')
    while(~isempty(qualified_vehicles))
        min = qualified_vehicles{1}.cost;
        bestveh{m} = qualified_vehicles{1};
        best = 1;
        for i = [1:length(qualified_vehicles)]
            if(qualified_vehicles{i}.cost < min)
                bestveh{m} = qualified_vehicles{i};
                min = qualified_vehicles{i}.cost;
                best = i;       
            end
        end
        %delete best entry from qualified vehicles
        fprintf(['\n   ' qualified_vehicles{best}.class ' | ' num2str(qualified_vehicles{best}.cost) '\n'])
        qualified_vehicles(best) = [];
        m = m+1;
    end
end
if(payload.risk == 1)
    fprintf('\n## Risk Optimization ##\n')
    while(~isempty(qualified_vehicles))
        min = (1 - qualified_vehicles{1}.reliability)*qualified_vehicles{1}.cost;
        bestveh{m} = qualified_vehicles{1};
        best = 1;
        for i = [1:length(qualified_vehicles)]
            if((1 - qualified_vehicles{i}.reliability)*qualified_vehicles{i}.cost < min)
                bestveh{m} = qualified_vehicles{i};
                min = (1 - qualified_vehicles{i}.reliability)*qualified_vehicles{i}.cost;
                best = i;       
            end
        end
        %delete best entry from qualified vehicles
        fprintf(['\n   ' qualified_vehicles{best}.class ' | ' num2str((1 - qualified_vehicles{best}.reliability)*qualified_vehicles{best}.cost) '\n'])
        qualified_vehicles(best) = [];
        m = m+1;
    end
end
if(payload.availiability == 1)
    fprintf('\n## Availability Optimization ##\n')
    while(~isempty(qualified_vehicles))
        max = qualified_vehicles{1}.availiability; 
        bestveh{m} = qualified_vehicles{1};
        best = 1;
        for i = [1:length(qualified_vehicles)]
            if(qualified_vehicles{i}.availiability > max)
                bestveh{m} = qualified_vehicles{i};
                max = qualified_vehicles{i}.availiability; 
                best = i;       
            end
        end
        %delete best entry from qualified vehicles
        fprintf(['\n   ' qualified_vehicles{best}.class ' | ' num2str(qualified_vehicles{best}.availiability) '\n'])

        qualified_vehicles(best) = [];
        m = m+1;
    end
end
if(payload.pmargin == 1)
    fprintf('\n## Performance Margin Optimization ##\n')
    while(~isempty(qualified_vehicles))
        max = qualified_vehicles{1}.pmargin; 
        bestveh{m} = qualified_vehicles{1};
        best = 1;
        for i = [1:length(qualified_vehicles)]
            if(qualified_vehicles{i}.pmargin > max)
                bestveh{m} = qualified_vehicles{i};
                max = qualified_vehicles{i}.pmargin; 
                best = i;       
            end
        end
        %delete best entry from qualified vehicles
        fprintf(['\n   ' qualified_vehicles{best}.class ' | ' num2str(qualified_vehicles{best}.pmargin) '\n'])
        qualified_vehicles(best) = [];
        m = m+1;
    end
end

