function [mass] = angular_res(len, rad, life, freq)

% INPUTS
% len: length of the satellite (m)
% rad: radius of orbit (km)
% life: mission lifetime (years)
% freq: frequency of momentum dumping (orbits/dump)

% OUTPUTS
% mass: mass of system including satellite body, reactions wheels, and
% propulsion system (kg)

% find mass and angular momentum of the structure
[structure_mass,w,l,I_xx,I_yy] = compute_truss_properties(len);

% find reaction wheels needed to counter-act gravity gradient torque
dI = abs(I_xx - I_yy);
[wheel_mass, momentum, tdumps] = reaction_wheels(rad*1000, dI, freq, life);

% find propulsion system
hydrazine_mass = compute_hydrazine_mass_for_momentum_dumping(momentum, tdumps);
[nitrogen_mass,tank_mass,tank_radius] = design_propulsion_system(hydrazine_mass);

mass = nitrogen_mass + tank_mass + hydrazine_mass + wheel_mass + structure_mass; 
