clear;
close all;

figure;
rad = 6600; %km
life = 2;   %years
len = 10:1:100; % vary length from 10 to 100 m
% vary frequency to dumping once each orbit to one every 100 orbits
mass = angular_res(len, rad, life, 1);
plot(len, mass);

hold on;
mass = angular_res(len, rad, life, 15);
plot(len, mass, 'g');

mass = angular_res(len, rad, life, 30);
plot(len, mass, 'r');

mass = angular_res(len, rad, life, 45);
plot(len, mass, 'y');

mass = angular_res(len, rad, life, 60);
plot(len, mass, 'c');

mass = angular_res(len, rad, life, 75);
plot(len, mass, 'm');

mass = angular_res(len, rad, life, 90);
plot(len, mass, 'k');




xlabel('Length of Structure [m]');
ylabel('Mass of System [kg]');
legend('Freq = Every 1 Orbit', 'Freq = Every 15 Orbits', 'Freq = Every 30 Orbits', ...
        'Freq = Every 45 Orbits', 'Freq = Every 60 Orbits', 'Freq = Every 75 Orbits', ...
        'Freq = Every 90 Orbits');
    
