clear;
close all;

baseline = 10:1:100;
[m,w,l,I_xx,I_yy] = compute_truss_properties(baseline);

figure;
plot(l,m);
xlabel('Truss Baseline Length [m]');
ylabel('Truss Mass [kg]');

figure;
plot(l,w);
xlabel('Truss Baseline Length [m]');
ylabel('Truss Width [m]');

figure;
plot(l,l./w);
xlabel('Truss Baseline Length [m]');
ylabel('Aspect Ratio');

figure;
plot(l,I_xx,'-',l,I_yy,'-.');
xlabel('Truss Baseline Length [m]');
ylabel('Mass Moment of Inertia [kg-m^2]');
legend('longitudinal','crossectional');

