function [nitrogen_mass,tank_mass,tank_radius] = design_propulsion_system(hydrazine_mass)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Constants
hydrazine_density = 1008.153082;                            % [kg/m^3]
titanium_allowable_stress = 830e6;                          % [N/m^2]
titanium_density = 4430;                                    % [kg/m^3]

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Design Assumptions
%   o Blowdown monopropellant system
%   o Hydrazine propellant
%   o Operating at 293.15 K
%   o Density of nitrogen gas calcuated using Beattie-Bridgeman Equation
safety_factor = 1.5;
maximum_expected_operating_pressure = 300*4.44822/0.0254^2; % [N/m^2]
end_of_life_pressure = 100*4.44822/0.0254^2;                % [N/m^2]
beginning_of_life_nitrogen_density = 23.88991766;           % [kg/m^3]
end_of_life_nitrogen_density = 7.939967137;                 % [kg/m^3]

initial_propellant_volume = hydrazine_mass./hydrazine_density;

tank_volume = initial_propellant_volume/...
              (1 - end_of_life_nitrogen_density/beginning_of_life_nitrogen_density);

nitrogen_mass = end_of_life_nitrogen_density*tank_volume;

% Assume negligible thickness: V = 4/3*pi*r^3
tank_radius = (3*tank_volume/4/pi).^(1/3);

tank_thickness = safety_factor*maximum_expected_operating_pressure*tank_radius/...
                 (2*titanium_allowable_stress);

% Assume thin wall: V = 4*pi*r^2*t
tank_mass = titanium_density*(4*pi*tank_radius.^2.*tank_thickness);



