clear;
close all;

safety_factor = 1.5;
maximum_expected_operating_pressure = 300*4.44822/0.0254^2; %[N/m^2]
hydrazine_mass = 1:1:100;
[nitrogen_mass,tank_mass,tank_radius] = design_propulsion_system(hydrazine_mass);

figure;
plot(hydrazine_mass,nitrogen_mass,hydrazine_mass,tank_mass,'-.');
xlabel('Propellant Mass [kg]');
ylabel('Tank and Pressurant Masses [kg]');
legend('Nitrogen Gas','Tank');

figure;
plot(hydrazine_mass,tank_radius);
xlabel('Propellant Mass [kg]');
ylabel('Tank Radius [m]');

pv_w = safety_factor*maximum_expected_operating_pressure*4/3*pi*tank_radius.^3./(tank_mass*9.81);

pv_w_database =...
[14429.98356
12567.17917
7529.383784
10652.08267
4417.741677
10004.62398
13831.00858
14738.43038
10171.42659
14253.15138
14243.29114
5474.496811
3619.787414
13426.48823
14967.45985
2957.866731
7008.294474
2957.866731
4809.415838
6356.298803
6544.35498
13390.34925
4432.392752
801.8313428
7392.07325
5288.371206
8001.26662
4192.508814
7185.122117
5750.158717
8334.405579
4714.188183
8234.044241
3950.164837
12700
6380.779732
7960.180655
7115.821412
9370.218315
11397.6204
4424.246172
8394.543505
5894.827127
12715.02959
12487.16771
3629.145931
7821.435196
6052.650974
8763.318045
12356.75676
7291.916389
7692.517423
11127.04324
6407.57576
5444.681535
3362.817303
9067.750289
6094.701888
9067.750289
7938.431528
6356.298803
7709.805532
6356.298803
8502.104096
6548.68397
8301.331255
10538.03501
5897.204497
11397.6204
3593.849198
6369.946489
6369.946489
4139.157695
10004.62398
6024.81523
3957.841801];

figure
plot(1:length(pv_w_database),pv_w_database,'.',1:length(pv_w_database),pv_w(1)*ones(length(pv_w_database)),'-');
xlabel('Data')
ylabel('PV/W [m]')
legend('Pressure Systems, Inc.','Calculated',4)

