function [mass, momentum, tdumps] = reaction_wheels(rad, dI, freq, life)

% INPUTS
% rad: radius of orbit (m)
% dI: abs(I_xx - I_yy), difference in moment of inertias (kg*m^2)
% freq: frequency momentum is dumped (orbits/dump)
% life: mission lifetime (years)

% OUTPUTS
% mass: mass of one reaction wheel
% momentum: momentum storage of one reaction wheel

% the worst-case angle of the satellite from the locat vertical is pi/4
% sin (2*pi/4) = 1

% Earth's gravity constant
mu = 3.986e14; % m^3/s^2

% gravity gradient torque Tg [Nm]
Tg = ((3*mu)/(2*rad^3))*dI;

% orbit period [sec]
P = 2*pi*sqrt(rad^3/mu);

% momomentum storage needed in reaction wheels
% assume inertially oriented: torque is cyclic
% for one orbit
m_orbit = Tg*(P/4)*0.707;

% momentum that could build between each dump
momentum = m_orbit*freq;

% get the polynomials for a curve fit of the wheel data
p = get_wheel_data;

% find the mass for the needed momentum value
mass = polyval(p, momentum);

% total orbits in the lifetime
torbits = life*365*24*3600/P;
% total number of momentum dumps
tdumps = torbits./freq;