function Delta_V_max = compute_impulsive_Delta_V_max(m_o, m_prop, mu, r, thruster)
% DELTA_V_MAX = COMPUTE_IMPULSIVE_DELTA_V_MAX(M_O,M_PROP)
%
% Inputs:
%   M_O             Initial total mass, i.e. m_dry + m_wet
%   M_PROP          Available propellant mass
%   MU              Gravitational constant of the body orbiting
%   R               radius of the initial orbit
%   TRUSTER         Thruster info
%
% Outputs:
%   DELTA_V_MAX     Maximum impulsive Delta V available

% reject any invalid inputs
if (m_o <= m_prop)
    error('Error! Propellant mass must be less than the initial spacecraft mass.');
end

theta = 2*pi/12;    % Angle of the orbit for wich the Delta V occurs. [rad]
                    % Assume pi/12 ~ 0, i.e. small angle approximation.
                    
g = 98.1;           % Earth gravity at sea level [m/s^2]

% Maximum propellant available during an impulsive burn. [kg]
Delta_m_max = min(m_prop, theta * thruster.T * r^(3/2) /...
                       (g*thruster.I_sp * sqrt(mu)));

% Maximum Delta_V available during an impulsive burn. [m/s]
Delta_V_max = g * thruster.I_sp * log(m_o/(m_o - Delta_m_max));



                    