function [Delta_V,Delta_t] = compute_spiral_transfer(mu,r_A,r_B,m_i,T)
% [DELTA_V,DELTA_T] = COMPUTE_SPIRAL_TRANSFER(MU,R_A,R_B,M_I,T)
%
% Inputs:
%   MU              Gravitational constant of the body orbiting
%   R_A             Radius of the inner circular orbit
%   R_B             Radius of the outer circular orbit
%   M_I             Initial Total Mass
%   T               Thrust
%
% Outputs:
%   DELTA_V         Total Delta_V necessary for Hohmann transfer
%   Delta_T         Hohman transfer time

% reject any invalid inputs
if (r_A > r_B)
    error('Error! Inner orbit radius is larger than the outer.');
end
if (T/m_i*g > 10e3)
    error('Error! Too much thrust for spiral transfer assumptions.');
end

a = T/m_i;                                  % Acceleration [m/s^2]
Delta_t = (sqrt(mu/r_A) - sqrt(mu/r_B))/a;  % Orbit transfer time [s]
Delta_V = a*Delta_t;                        % Total Delta V required for orbit transfer [m/s]
