clear;
close all;

mu = 398600.5e9;    % Earth gravitational constant [m^3/s^2]
g = 9.81;           % Earth gravity [m/s^2]
T = 0.5;            % Thrust: Ion Thruster max thrust [N]
I_sp = 5000;        % I_sp [s]
m = 1000;           % Spacecraft mass [kg]

a = T/m;            % Acceleration [m/s^2]

r_o = 6000000;      % Original radius [m]
r_f = 7000000;     % Final radius [m]

% Orbit Transfer Time [s]
Delta_t = (sqrt(mu/r_o) - sqrt(mu/r_f))/a;

% Required Delta_V [m/s]
Delta_V = a * Delta_t;

%step_size = 3000;
%t_f = Delta_t; %2.6486e4;
%t = 0:t_f/step_size:t_f;
%r = 1./((1/sqrt(r_o) - a/sqrt(mu)*t).^2);
%theta(1) = 0;
%for i = 2:length(r)
%    theta(i) = theta(i-1) + sqrt(mu)/(r(i)^(3/2))*(t(i)-t(i-1));
%end

d_theta = 0.005;
theta = 0:d_theta:5*2*pi;
t(1) = 0;
for i = 2:length(theta)
    t(i) = t(i-1) + r_o^(3/2)/sqrt(mu)*(theta(i)-theta(i-1));
end
r = 1./((1/sqrt(r_o) - a/sqrt(mu)*200*t).^2);
polar(theta,r);