clear;
close all;
mu = 398600.5e9;        % Earth gravitational constant [m^3/s^2]
r_A = 6570e3;           % Initial circular orbit [m]
r_B = 42200e3;          % Final circular orbit [m]
a_tx = 28633e3;

e = 1 - r_A/a_tx;
nu = acos((a_tx*(1-e^2)/r_B - 1)/e);
%nu = acos((a_tx*(1-e^2)/(r_B - 1))/e);
phi = atan(e*sin(nu)/(1+e*cos(nu)));
v_iA = sqrt(mu/r_A);
v_txA = sqrt(mu*(2/r_A - 1/a_tx));
Delta_V_A = v_txA - v_iA;
v_txB = sqrt(mu*(2/r_B - 1/a_tx));
v_fB = sqrt(mu/r_B);
Delta_V_B = sqrt(v_fB^2 + v_txB^2 - 2*v_fB*v_txB*cos(phi));
%Delta_V_B = sqrt(v_fB^2 + v_txB^2 - 2*v_fB*v_txB*cos(nu));
Delta_V = Delta_V_A + Delta_V_B
E = atan(sqrt(1-e^2)*sin(nu)/(e+cos(nu)));
TOF = sqrt(a_tx^3/mu)*(E-e*sin(E))
%TOF = sqrt(mu/a_tx^3)*(E-e*sin(E))

v_txB_ = 0:1:4000;
a_tx_ = 1./(2/r_B - v_txB_^2/mu);
e_ = 1-r_A./a_txB_;

x = v_txB_.^2 + v_fB^2- 2*v_fB.*v_txB_.*((a_tx*(1-(1-r_A./() ...
    - Delta_V_B^2;