%*****************************
%  input: requirements and constraints for power subsystem solar array
%  design
% P_d - average power required during the day (W)
% P_e - average power required during the eclipse (W)
% T_d - time in the daylight (minutes)
% T_e - time in the eclipse (minutes)
% eff - efficiency of solar array material (%)
% degrad - degradation of solar array material/year (%)
% lftme - lifetime of satellite (yrs)
%  output: array area (m^2)


function area = ArrayDesign(P_d, P_e, T_d, T_e, lftme, degrad, eff)
                            
% ******ASSUMPTION*******%
solar_constant = 1367; %[W/m^2]
                            
% calculate amount of power that must be produced by 
% solar arrrays

P_sa = calcPW(P_d, P_e, T_d, T_e); %[W]

% calculate estimated Power output P_o

P_o = eff*solar_constant; %[W/m^2]

% determine the beginning of life power production capability
% ******ASSUMPTION****** - we are using nominal value for I_d
I_d = 0.77;
% ******ASSUMPTION****** - The solar array is at worstcase Sun angle
% between equatorial and ecliptic planes
theta = 0.4101;

P_bol = pwrBOL(P_o, I_d, theta);

% Determine the end of life power production for the solar array

P_eol = perfDegrad(P_bol, degrad, lftme);

% Estimate the solar array area required to produce the necessary power,
% P_sa, base on P_eol

area = P_sa/P_eol;



