%  calculates amount of power that must be produced by solar arrays
%  inputs:
% P_d - average power required during the day
% P_e - average power required during the eclipse
% T_d - time in the daylight (minutes)
% T_e - time in the eclipse (minutes)
% output: power required

function P_sa = calcPW(P_d, P_e, T_d, T_e)

% equation 11-5 from SMAD
% *****ASSUMPTION*****: direct energy transfer regulation scheme
% with X_e = 0.65 & X_d = 0.85

X_e = 0.65;
X_d = 0.85;

P_sa = ((P_e*T_e/X_e) + (P_d*T_d/X_d))/T_d;