% Determine the end of life power production for the solar array
% input: 
% P_bol - power at beginning of life (W/m^2)
% degrad - degradation of array material per year (%/yr)
% lftme - lifetime of satellite (yrs.)
% output - power at end of life (W/m^2)

function P_eol = perfDegrad(P_bol, degrad, lftme)

P_eol = P_bol*((1 - degrad)^lftme);
