% determines the beginning of life power production
% capability
% input:
% P_o - estimated power output (W/m^2)
% I_d - inherent degradation, efficiency for array including design (%)
% inefficiencies, shadowing, and temperature variations
% theta - Sun incidence angle between the vector normal to the surface
% of the array and the sun line (must be radians)
% output: power at beginning of life (W/m^2)

function P_bol = pwrBOL(P_o, I_d, theta)

P_bol = P_o*I_d*cos(theta);