function P = SolarPowerPerArea(solar_array, effective_intensity, t);
% P = SOLARPOWERPERAREA(SOLAR_ARRAY, EFFECTIVE_INTENSITY, T)
%
%  Inputs
%       SOLAR_ARRAY         Specifies the type and the specificatution of solar array
%       EFFECTIVE_INTENSITY Effective power intensity due to incident angles.
%       T                   Time sequence.
% Outpus 
%       P                   Power per area of a solar array.

if (length(t) ~= length(effective_intensity))
    error('The length of the vectors of effective intensity and time do not match.');
    P = 0;
else
    t_0 = t(1);
    for i = 1:length(t)
        P(i) = CurrentPowerPerArea(solar_array, effective_intensity(i), t_0, t(i));
    end
end

function P_current = CurrentPowerPerArea(solar_array, effective_intensity, t_0, t)
P_current = solar_array.Efficiency * solar_array.InherentDegradation ...
  * (1 - (solar_array.InitialDegradation + solar_array.DegradationRate ...
  * (t - t_0))) * effective_intensity;