clear;
close all;
% Initial Time [sec]
t_0 = 0;

% Final Time [sec]
t_f = 5 * 24 * 3600;

% Time Increment [sec]
dt = 50;
t = t_0:dt:t_f;

environment.IlluminationIntensity = 1367*ones(1,length(t));

[storage, generation, solar] = power_read_xls('power_design_vector.xls');

% Obital Period [sec]
op = 90 * 60;

% Incident Angle [rad]
incident_angle = 0*t;

% Power Load
power_load = 100 * sin(t/t_f*pi);

power_source{1} = solar(1);
power_source{1}.IncidentAngle = incident_angle;
power_source{2} = solar(3);
power_source{2}.IncidentAngle = incident_angle;
power_source{1} = generation(1);

energy_storage = storage(1);
energy_storage.InitialCharge = 30;
energy_storage.RemainingLife = 1;

area = [1 2 3 4 5]; %[m^2]

for i=1:length(area)
    power_source{1}.SurfaceArea = area(i); %[m]
    power_source{2}.SurfaceArea = area(i); %[m]
    design(i) = PowerDesignResult(power_source, energy_storage, power_load, environment, t);
end

for i=1:length(area)
    figure(1)
    hold on
    plot(area(i),design(i).Mass,'o');
    figure(2)
    hold on
    plot(area(i),design(i).Cost,'o');
    figure(3)
    hold on
    plot(t,design(i).AvailablePower);
    figure(4)
    hold on
    plot(t,design(i).AvailableEnergy);
end
