clear all

%take in the design vector
[storage, generation, solar] = power_read_xls('power_design_vector.xls');

%storage type           Number
%Nickel-Hydrogen IPV    1
%Nickel-Hydrogen CPV    2
%Lithium Ion            3  
%Silver Zinc            4
%Fly Wheel              5

[ENV]=environmentfun;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%INPUTS$$$$$$$$$$$$$$$$%%%%%%%%%%%%%%%%%%%%
%take in data file
%[data,clocks] = xlsread('MER_sol4_input_data.xls'); %sample data file
%[time, L, A]=parseinputdata(data,clocks);

%time vector
t_f = 5 * 24 * 60;
dt=60;
time = dt*[0:1:t_f];

% Orbital Period [sec]
op = 90 * 60;

% Incident Angle [rad]
%incident_angle = 0:2*pi/op*dt:time(length(time))*2*pi/op;
%incident_angle = mod(0:2*pi/op*dt:time(length(time))*2*pi/op,pi) - pi/2*ones(1,length(time));
incident_angle = mod(0:2*pi/op*dt:time(length(time))*2*pi/op,pi) - pi/2*ones(1,length(time));
for i = 1:length(incident_angle)
    if mod(i,91) > 41
        incident_angle(i) = pi/2;
    end
end
%power_load requirement(W)
%power_load = 75 + 25 * sin(time);
power_load(1:length(time)) = 100 + 50*round(sin(time*3*pi/3600));

life_init = 1.0;                % fraction of life span remaining at start of period
energy_max     = 44.8*3600;  % Joules
energy_initial = 0.59*energy_max;% Joules

%solar array vector
SA_area=1:1:4; %m^2

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

storage_design_length=length(storage); %find max length of storage design
generation_design_length=length(generation);%find max length of generator design
solar_design_length=length(solar);%find max length of solar design
SA_design_length=length(SA_area);
stcnt=1;%storage counter
socnt=1;%solar cnt
gecnt=1;%generator cnt
SAcnt=1;

%debug code

for stcnt=1:storage_design_length
    
    storage(stcnt).InitialCharge=energy_initial;
    %  storage(stcnt).InitialCharge=0;
    
    storage(stcnt).RemainingLife=life_init;
    
    'solar cycle'
    
    %Pick either SOlar or RTG (generation)
    for socnt=1:solar_design_length
        for SAcnt=1:SA_design_length
            %outside loop
            solar(socnt).IncidentAngle =  incident_angle;
            solar(socnt).SurfaceArea =  SA_area(SAcnt);
            
            SAResult(stcnt,socnt,SAcnt)= PowerDesignResult({solar(socnt)}, storage(stcnt), power_load,ENV,time);
        end
    end %done with Solar options
    
    'RTG cycle'

    %try RTG options
    for gecnt=1:generation_design_length
        RTGResult(stcnt,gecnt) = PowerDesignResult({generation(gecnt)}, storage(stcnt), power_load,ENV,time);
    end
end



