function [time, L, A]=parseinputdata(data,clocks)
% the load power
val = data(:,1);
val = val(find(val(:,1)>=0));
times = clocks(:,1);
times = times(1:length(val));
time  = t2ms(times);
[tL,L] = create_profile(time, val, 4);

% the array power
val = data(:,3);
val = val(find(val(:,1)>=0));
times = clocks(:,3);
times = times(1:length(val));
time  = t2ms(times);
[tA,A] = create_profile(time, val, 0);

if (sum(tA-tL)~=0)
    error('Error!  Load and input power profiles have different time vectors.');
end


% changes the specified segment of the history
function [output] = mod_segment(input, time0, time1, endval)
t0 = t2m(time0);
t1 = t2m(time1);
dt = t1-t0;
output = input;
output(t0+1:t1) = (endval-input(t0))/dt*(1:dt)+input(t0);


% creates corner value hh:mm to minutes
function corner_times = t2ms(times)
for i=1:length(times)
    corner_times(i) = t2m(times{i});
end


% creates a power profile given corner values.  corner_times must be integers.
function [t,L] = create_profile(corner_times, corner_values, initial)
if length(corner_times) ~= length(corner_values)
    error('Error!  Invalid input to create_profile()');
end
if sum(corner_times==round(corner_times))~=length(corner_times)
    error('Error!  Input to create_profile() ''corner_times'' must contain only integers.');
end
t = 0:corner_times(length(corner_times));
if (corner_times(1) ~= 0)
    corner_times = [0 corner_times];
    corner_values = [initial corner_values];
end
for i=1:length(corner_times)-1
    t0 = corner_times(i);
    t1 = corner_times(i+1);
    dt = t1-t0;
    L(t0+2:t1+1) = (corner_values(i+1)-corner_values(i))/dt*(1:dt)+corner_values(i);
end
L(1) = initial;


% changes hh:mm to number of minutes since midnight
function [min] = t2m(time)
div = find(time==':');
if length(div)~=1
    error('Error!  Invalid input to function t2m().');
end
min = str2num(time(1:div-1))*60 + str2num(time(div+1:length(time)));

