function [storage, generation, solar] = power_read_xls(filename)
%[STORAGE, GENERATION, SOLAR] = POWER_READ_XLS(FILENAME)
%
% Reads in data from the Excel file FILENAME, and parses it into 
% data structures.  The file must contain sheets named 'Storage',
% 'Generation', and 'Solar', and the sheets must be arranged in
% a particular format, or an error will result.  See the file
% 'power_design_vector.xls' for an example of proper format.
%

storage    = [];
generation = [];
solar      = [];

% read in the energy storage info
[num, txt] = xlsread(filename,'Storage');

% add on new field names one by one
for i=1:size(txt,1)
    storage = setfield(storage, txt{i,1}, []);
end

names = fieldnames(storage);
i_offset = size(txt,1) - size(num,1);
j_offset = size(txt,2) - size(num,2);

for i=1:size(txt,1)
    for j=3:size(txt,2)
        if i<=i_offset
            eval(['storage(j-2).',names{i},'= ''',txt{i,j}, ''';']);
        else
            eval(['storage(j-2).',names{i},'= num(i-i_offset,j-j_offset);']);
        end
    end
end

% read in the power generation info
[num, txt] = xlsread(filename,'Generation');

for i=1:size(txt,1)
    generation = setfield(generation, txt{i,1}, []);
end

names = fieldnames(generation);
i_offset = size(txt,1) - size(num,1);
j_offset = size(txt,2) - size(num,2);

for i=1:size(txt,1)
    for j=3:size(txt,2)
        if i<=i_offset
            eval(['generation(j-2).',names{i},'= ''',txt{i,j}, ''';']);
        else
            eval(['generation(j-2).',names{i},'= num(i-i_offset,j-j_offset);']);
        end
    end
end

% read in the solar array info
[num, txt] = xlsread(filename,'Solar');

for i=1:size(txt,1)
    solar = setfield(solar, txt{i,1}, []);
end

names = fieldnames(solar);
i_offset = size(txt,1) - size(num,1);
j_offset = size(txt,2) - size(num,2);

for i=1:size(txt,1)
    for j=3:size(txt,2)
        if i<=i_offset
            eval(['solar(j-2).',names{i},'= ''',txt{i,j}, ''';']);
        else
            eval(['solar(j-2).',names{i},'= num(i-i_offset,j-j_offset);']);
        end
    end
end
