function gst = find_gst(yr, mo, d, h, min)

% routine from Fundamentals of Astrodynamics and Applications, by Vallado
% first converts normal date format to julian date for the day
% then converts julian date and the time of day to greenwich sidereal time 

% earth's mean angular rotation
w = 0.250684477337;

jd = 367*yr - floor((7*(yr + floor((mo+9)/12)))/4) + floor(275*mo/9) + d + 1721013.5;

tjd_ut = (jd - 2451545)/36525;

gst_day = 100.4606184 + 36000.77005361*tjd_ut + 0.00038793*tjd_ut^2 - (2.6e-8)*tjd_ut^3;

gst = gst_day + w*(h*60 + min);

while(gst > 360)
    gst = gst-360;
end
while(gst < 0)
    gst = gst + 360;
end