function [data_sent, power] = transmitter(dr, pass_time)

% INPUTS
% dr: data rate of data transmitted from spacecraft to groundsite, in bps
% pass_time: average time of each spacecraft pass where downlink is made (minutes)

% OUTPUTS
% data_sent: average amount of data that can be sent each pass (bits)
% power: power needed for each tranmission (W)


% ASSUMPTIONS
% 1. The ground station antenna has a diameter of 5 meters
% 2. every pass will result in a transmission, the ground antenna is
% dedicated to receiving transmissions and will never break (so M in
% equation 13-2 in SMAD == 1)
% 3. T_initiate in eq 13-2 is 2 minutes, which is given as a typical value
% by SMAD
% 4. Having STK calcuate the access times allows as to ignore the value F
% in eq 13-2, since STK takes the exact pass position into account


% From figure 13-5 from SMAD
% power for different data rates
% for the ground station diameter of 5 meters, the plot indicates that
% power is equal to approximately 10x the data rate, in Mbps

power = 10*(dr/10e5);

% total data sent on each pass (on average)
data_sent = dr*(pass_time*60 - 2*60);

disp('Power needed for data transmission (W): ');
disp(power);
disp('Bits of data sent each transmission: ');
disp(data_sent);