function [r, v] = ae2rv(a, e, MU)

% function ae2rv calculates the scalar minimum radius (rp) and maximum 
%   velocity for a spacecraft in a circular or elliptical orbit

% a  [   m   ]: semimajor axis of the orbit
% e  [       ]: eccentricity of the orbit
% MU [m^3/s^2]: gravitational parameter for the central body

r = a*(1 - e);   % radius of perigee

v = sqrt(2*(MU/r - MU/(2*a)));  % velocity at perigee

