function momentum = momwheelsizing(t_aero,t_bfield,t_gg,t_solar,accu, orbit_period)

% function momwheelsizing.m sizes momentum wheels:

% t_aero,t_bfield,t_gg,t_solar [N m]- disturbance torques from the environment
% accu [degrees] - accuracy needed
% orbit_period [min] - orbit period

if(t_aero > t_bfield && t_aero > t_gg && t_aero > t_solar)
    t_d = t_aero;
elseif(t_bfield > t_aero && t_bfield > t_gg && t_bfield > t_solar)
    t_d = t_bfield;
elseif(t_gg > t_aero && t_gg > t_bfield && t_gg > t_solar)
    t_d = t_gg;
else
    t_d = t_solar;
end

momentum = (t_d*orbit_period*60)/(4*0.01745*accu);