function [actuator1, actuator2] = obj2actuator(pointing_accu, pointing_req, slew_rate)

% function obj2actuator.m maps mission requirements to acuator choices:

% pointing_accu [degrees]: pointing accuracy required for mission
% pointing_req [  ]: where you want your spacecraft pointing (ep == earth-pointing,
% ip == inertial pointing)
% slew rate [deg/s]: maximum slew rate required for spacecraft

if(pointing_accu > 5)
    control_type = 'gg';
elseif(pointing_accu < 5 && pointing_accu > 1)
    control_type = 'ss';
else
    control_type = '3ax';
end

if(strcmp(pointing_req, 'ep') == 1)
    if(strcmp(control_type, 'gg') == 1)
        actuator1 = 'mw';
        actuator2 = 'mw';
    elseif(strcmp(control_type, '3ax') == 1)
        actuator1 = 'rw';
        actuator2 = 'cmg';
    else
        actuator1 = 'rw';
        actuator2 =  'thruster';
    end
else
    actuator1 = 'rw';
    actuator2 = 'thruster';
end

if(slew_rate < 0.05 && strcmp(actuator2, 'thruster') == 1)
    actuator2 = 'magtor';
end
if((slew_rate > 0.05  || slew_rate == 0.05) && slew_rate < 0.5 && strcmp(actuator2, 'thruster') ~= 1)
    actuator2 = 'thruster';
end
if (slew_rate > 0.5 || slew_rate == 0.5)
    actuator2 = 'cmg';
end

   