function [torque, momentum] = reacwheel_cmgsize(t_aero,t_bfield,t_gg,t_solar,slew_dist,slew_time, craft_inertia, orbit_period)


% function reacwheel&cmgsize.m sizes reaction wheels and cmgs:

% t_aero,t_bfield,t_gg,t_solar [N m]- disturbance torques from the environment
% slew_dist [degrees] - amount needed to slew
% slew_time [seconds] - amount of time needed to slew
% craft_inertia [kg.m^2] - spacecraft moment of inertia
% orbit_period [min] - orbit period
% torque [N.m] - torque required
% momentum = [N.m.s] - angular momentum required

if(t_aero > t_bfield && t_aero > t_gg && t_aero > t_solar)
    t_d = t_aero;
elseif(t_bfield > t_aero && t_bfield > t_gg && t_bfield > t_solar)
    t_d = t_bfield;
elseif(t_gg > t_aero && t_gg > t_bfield && t_gg > t_solar)
    t_d = t_gg;
else
    t_d = t_solar;
end

margin = 10; % margin factor for disturbance rejection

torque_d = 10*t_d;

torque_slew = (4*slew_dist*0.01745*craft_inertia)/(slew_time)^2;

if(torque_slew > torque_d)
    torque = torque_slew;
else
    torque = torque_d;
end

% 0.707 is the rms average of the sinusoidal function
momentum = (t_d*orbit_period*60*0.707)/4;
