function torque = t_aero(h, Cd, A, v, rt)

% function t_aero.m calculates the aerodynamic torque on a vehicle given
%     the following inputs:

% h  [ m ]: minimum altitude of spacecraft (rp - re)
% Cd [   ]: the coefficient of drag on the spacecraft
% A  [m^2]: the "shadow area" of the spacecraft (worst-case cross-sectional area)
% v  [m/s]: the velocity of the spacecraft (velocity at perigee)
% rt [ m ]: the moment arm for the drag force (center of pressure - center of mass)

rho_max = [5.10e-7; 2.04e-9; 3.52e-10; 1.06e-10; 3.96e-11; 1.66e-11; 7.55e-12; 3.61e-12; ...
           1.80e-12; 9.25e-13; 4.89e-13; 2.64e-13; 1.47e-13; 8.37e-14; 4.39e-14; 3.00e-14; 1.91e-14; ...
           1.27e-14; 8.84e-15; 2.59e-15; 1.22e-15];   % densities during solar max [kg/m^3]
rho_alt = [100; 150; 200; 250; 300; 350; 400; 450; 500; 550; 600; 650; ...
           700; 750; 800; 850; 900; 950; 1000; 1250; 1500]*1000;   % corresponding altitudes in [m]

rho = spline(rho_alt, rho_max, h);  % interpolate the density [kg/m^3]

F_aero = (1/2)*rho*Cd*A*v*v;  % aerodynamic drag force [N]

torque = F_aero*rt;  % aerodynamic torque [N*m]





% semilogy(rho_alt, rho_max)    % can plot the densities on a log scale
% grid on