function torque = t_bfield(r, D)

% function t_bfield.m calculates the gravity gradient torque on a vehicle given
%     the following inputs:

% r [m]: minimum radius from center of massive body to spacecraft
% D [amp*m^s]: residal dipole of the vehicle

M = 7.96e15;   % [tesla*m^3], magnetic moment of the Earth
B = (2*M)/r^3;  % [tesla], earth's magnetic field

torque = D*B;