function torque = t_gg(r, Imax, Imin, MU)

% function t_gg.m calculates the gravity gradient torque on a vehicle given
%     the following inputs:

% r [m] : minimum radius from center of massive body to spacecraft
% Imax, Imin [kg*m^2]: maximum and minimum moments of inertia of the spacecraft
% MU [m^3/s^2]: gravitational parameter for the central body

torque = (3*MU/(2*r^3))*(Imax - Imin);