function torque = t_solar(A, rt)

% function t_solar.m calculates the solar radiation torque on a vehicle given
%     the following inputs:

% A  [m^2]: the "shadow area" of the spacecraft (worst-case cross-sectional area)
% rt [ m ]: the moment arm for the drag force (center of pressure - center of mass)

Fs = 1367;  % [W/m^2], solar constant at 1AU
c = 3e8;    % [m/s], speed of light
q = 0.6;    % [ ], reflectance factor

torque = (Fs/c)*A*(1+q)*rt;