function force = thrustersizing(t_aero,t_bfield,t_gg,t_solar,slew_dist,slew_time,moment_arm,craft_inertia)

% function thrustersizing.m sizes thrusters:

% t_aero,t_bfield,t_gg,t_solar [N m]- disturbance torques from the environment
% slew_dist [degrees] - amount needed to slew
% slew_time [seconds] - amount of time needed to slew
% moment_arm = [ m ] - moment arm
% craft_inertia [kg.m^2] - spacecraft moment of inertia


if(t_aero > t_bfield && t_aero > t_gg && t_aero > t_solar)
    t_d = t_aero;
elseif(t_bfield > t_aero && t_bfield > t_gg && t_bfield > t_solar)
    t_d = t_bfield;
elseif(t_gg > t_aero && t_gg > t_bfield && t_gg > t_solar)
    t_d = t_gg;
else
    t_d = t_solar;
end


%force level sizing
force1 = t_d/moment_arm;

%sizing force to meet slew rate accelerating for 5% of the time, coasting
%for 90% and decelerating for 5%.

slew_rate = slew_dist/slew_time;

accel_time = 0.05*slew_time;

accel = slew_rate/accel_time;
force2 = (craft_inertia*accel)/moment_arm;

if(force1 > force2)
    force = force1;
else
    force = force2;
end