 function mass = datamassstorage_sizing(data_rate, t_max, weight_factor)
 
 % data_rate [bps] - data rate required
 % t_max [seconds] - coverage time (amount of time satellite can transmit
 % to ground station
 % weight_factor [kg/bytes] - constant related to data storage device
 
 
 % constants
 F = 0.8; %from SMAD this is an average value for satellites in a circular LEO-Earth orbit
 t_init = 120; %seconds, estimate from SMAD
 M = 2; % estimate from SMAD, this is a conservative estimate unless it is a dedicated ground
 %station with a specified value for the percentage of pass time that will
 %be used for collecting data
 
 data_quantity = data_rate*(F*t_max - t_init)/M;
 
 mass = data_quantity*weight_factor;
 
 